/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.dao;

import com.swimap.base.framework.FileUtil;
import com.swimap.base.framework.Framework;
import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlUtil {
    private static final String CONFIG_EXT_NAME = ".database";
    private static final String CONFIG_DRIVER = "driver";
    private static final String DRIVER_NAME_SQLSERVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DEFAULT_DRIVER = System.getProperty("datasource.driver");
    private static Log log = LogFactory.getLog(SqlUtil.class);
    private boolean isSqlServer = false;
    private static final int SQLSERVER = 0;
    private static final int SYBASE = 1;
    private static final int ORACLE = 2;

    public SqlUtil(String dsName) {
        try {
            File config = this.getConfigFile(dsName);
            Properties prop = new Properties();
            if (FileUtil.checkReadFile(config)) {
                prop.load(config.toURI().toURL().openStream());
            }
            String driverString = prop.getProperty(CONFIG_DRIVER, DEFAULT_DRIVER);
            this.isSqlServer = DRIVER_NAME_SQLSERVER.equals(driverString);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
    }

    public boolean isSqlServer() {
        return this.isSqlServer;
    }

    public String convertSql(String sql) {
        String newSql = sql;
        if (this.isSqlServer) {
            newSql = SqlUtil.convertSqlToSqlServer(sql);
        }
        return newSql;
    }

    private File getConfigFile(String dsName) throws Exception {
        File parent = Framework.getConfigDir();
        String configFilename = dsName;
        if (!configFilename.endsWith(CONFIG_EXT_NAME)) {
            configFilename = configFilename + CONFIG_EXT_NAME;
        }
        return new File(parent, configFilename);
    }

    public static String convertSqlToSqlServer(String sql) {
        int length = sql.length();
        StringBuilder builder = new StringBuilder(length + 100);
        boolean startWithN = false;
        boolean inString = false;
        boolean inEscape = false;
        for (int i = 0; i < length; ++i) {
            char c = sql.charAt(i);
            if (c == 'N') {
                builder.append('N');
                if (inString) continue;
                startWithN = true;
                continue;
            }
            if (c == '\'') {
                if (!inString) {
                    if (!startWithN) {
                        builder.append('N').append('\'');
                    } else {
                        builder.append('\'');
                    }
                    inString = true;
                } else {
                    builder.append('\'');
                    inEscape = !inEscape;
                }
                startWithN = false;
                continue;
            }
            builder.append(c);
            if (inString && inEscape) {
                inEscape = false;
                inString = false;
            }
            startWithN = false;
        }
        return builder.toString();
    }

    private void convert() {
    }

    public static String transDBUpdateString(String info) {
        info = info.replaceAll("'", "''");
        return info;
    }

    public static String transDBSearchString(String info, int dbType) {
        log.error((Object)("SqlUtil | transDBSearchString | info before: " + info + " | dbType : " + dbType));
        char[] input = info.toCharArray();
        StringBuffer rs = new StringBuffer();
        block7: for (char c : input) {
            switch (c) {
                case '%': {
                    if (dbType == 2) {
                        rs.append("\\%");
                        continue block7;
                    }
                    rs.append("[%]");
                    continue block7;
                }
                case '_': {
                    if (dbType == 2) {
                        rs.append("\\_");
                        continue block7;
                    }
                    rs.append("[_]");
                    continue block7;
                }
                case '\\': {
                    if (dbType == 2) {
                        rs.append("\\\\");
                        continue block7;
                    }
                    rs.append(c);
                    continue block7;
                }
                case '[': {
                    if (dbType == 0 || dbType == 1) {
                        rs.append("[[]");
                        continue block7;
                    }
                    rs.append(c);
                    continue block7;
                }
                case ']': {
                    if (dbType == 1) {
                        rs.append("[]]");
                        continue block7;
                    }
                    rs.append(c);
                    continue block7;
                }
                default: {
                    rs.append(c);
                }
            }
        }
        return rs.toString();
    }

    public static String getEscapeString(int dbType) {
        if (dbType == 2) {
            return " ESCAPE '\\' ";
        }
        return "";
    }
}

