/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.dao;

import com.swimap.base.framework.dao.DB2ServerManager;
import com.swimap.base.framework.dao.MemServerManager;
import com.swimap.base.framework.dao.OracleManager;
import com.swimap.base.framework.dao.PostgresManager;
import com.swimap.base.framework.dao.SqlManager;
import com.swimap.base.framework.dao.SqlServerManager;
import com.swimap.base.framework.dao.SybServerManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class SqlManagerFactory {
    private static SqlManagerFactory instance;

    SqlManagerFactory() {
    }

    static void setFactory(SqlManagerFactory factory) {
        instance = factory;
    }

    public static SqlManagerFactory instance() {
        if (instance == null) {
            instance = new SqlManagerFactory();
        }
        return instance;
    }

    public SqlManager createSqlManager(Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        if (metaData == null) {
            throw new SQLException("DatabaseMetaData returned by Connection [" + conn + "] was null");
        }
        String productName = metaData.getDatabaseProductName();
        if (productName.indexOf("Microsoft SQL Server") != -1) {
            return new SqlServerManager();
        }
        if ("Adaptive Server Enterprise".equals(productName) || "Sybase SQL Server".equals(productName) || "sql server".equals(productName)) {
            return new SybServerManager();
        }
        if (productName.indexOf("DB2") != -1) {
            return new DB2ServerManager();
        }
        if (productName.indexOf("Oracle") != -1) {
            return new OracleManager();
        }
        if ("PostgreSQL".equals(productName)) {
            return new PostgresManager();
        }
        if ("HSQL Database Engine".equals(productName)) {
            return new MemServerManager();
        }
        throw new SQLException(productName + " is not a supported database");
    }
}

