/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.dao;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PoolDataSource
implements DataSource {
    private static final long GET_CONN_MAX_WAIT_TIME = 90000L;
    private static final Log log = LogFactory.getLog(PoolDataSource.class);
    private static final int CON_TIMEOUT = 600;
    private String name;
    private String url;
    private String dbInfo;
    private static boolean isSybase = "sybase".equals(System.getProperty("datasource.dbType"));

    public void setDBInfo(String dbInfo) {
        this.dbInfo = dbInfo;
    }

    PoolDataSource(String name) {
        this.name = name;
        this.url = "proxool." + name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Connection getConnection() throws SQLException {
        long timeStart;
        long timeEnd = timeStart = System.currentTimeMillis();
        Connection conn = null;
        DriverManager.setLoginTimeout(600);
        while (true) {
            try {
                conn = DriverManager.getConnection(this.url);
                return this.getConnectionByUseDB(conn);
            }
            catch (SQLException sqle) {
                if (null != conn) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        log.error((Object)"", (Throwable)e);
                    }
                }
                if (sqle.toString().contains("simultaneous builds")) {
                    timeEnd = System.currentTimeMillis();
                    long timePeriod = timeEnd - timeStart;
                    if (timePeriod >= 90000L) {
                        log.error((Object)"getConnection failed!");
                        throw sqle;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"", (Throwable)e);
                    }
                    continue;
                }
                log.error((Object)"DriverManager getConnection faild.", (Throwable)sqle);
                throw sqle;
            }
            break;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.url, username, password);
            return this.getConnectionByUseDB(conn);
        }
        catch (SQLException sqle) {
            if (null != conn) {
                conn.close();
            }
            throw sqle;
        }
    }

    public Connection getConnectionByUseDB(Connection connection) throws SQLException {
        if (isSybase && this.dbInfo != null) {
            Statement sta = connection.createStatement();
            sta.execute(String.format("use %s", this.dbInfo));
            sta.close();
        }
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() {
        return new PrintWriter(System.out);
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("This mothod is not supported which inherited from jre1.7");
    }
}

