/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.dao;

import com.swimap.base.framework.FileUtil;
import com.swimap.base.framework.Framework;
import com.swimap.base.framework.ResUtil;
import com.swimap.base.framework.dao.DAO;
import com.swimap.base.framework.dao.DB2ServerManager;
import com.swimap.base.framework.dao.DataSourceHolder;
import com.swimap.base.framework.dao.SqlManager;
import com.swimap.base.framework.dao.SqlManagerFactory;
import com.swimap.base.sysconfigure.ConfigTool;
import com.swimap.external.dsf.base.framework.dao.ExtendProperties;
import java.io.File;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.admin.SnapshotIF;

public class DataSourceManager {
    private static Log log = LogFactory.getLog(DataSourceManager.class);
    private static final String DEFAULT_MAX_POOL_SIZE = "100";
    private static final String DEFAULT_MIN_POOL_SIZE = "0";
    private static final String DEFAULT_MAX_ACTIVE_TIME = "300000";
    private static final String DEFAULT_PASSWORD = System.getProperty("datasource.password");
    private static final String DEFAULT_USERNAME = System.getProperty("datasource.user");
    private static final String DEFAULT_URL = DataSourceManager.getDefaultURL();
    private static final String DEFAULT_DRIVER = System.getProperty("datasource.driver");
    private static final String DEFAULT_IPADDRESS = System.getProperty("datasource.dbServerIP");
    private static final String DEFAULT_DBPORT = System.getProperty("datasource.dbServerPort");
    private static final String DEFAULT_DBSERVERNAME = System.getProperty("datasource.dbServerName");
    private static final String CONFIG_MAX_POOL_SIZE = "maxPoolSize";
    private static final String CONFIG_MIN_POOL_SIZE = "minPoolSize";
    private static final String CONFIG_MAX_ACTIVE_TIME = "maxActiveTime";
    private static final String CONFIG_PASSWORD = "password";
    private static final String CONFIG_USERNAME = "username";
    private static final String CONFIG_URL = "url";
    private static final String CONFIG_DRIVER = "driver";
    private static final String CONFIG_EXT_NAME = ".database";
    private static final String CONFIG_DBINFO = "dbInfo";
    private Map<String, DataSourceHolder> dsMap = new ConcurrentHashMap<String, DataSourceHolder>();
    private static final DataSourceManager DEFAULT_INSTANCE;
    private static DataSourceManager instance;
    private static final int INDEX_URL = 0;
    private static final int INDEX_USER = 1;
    private static final int INDEX_PASSWORD = 2;

    private static String getDefaultURL() {
        String url = System.getProperty("datasource.url");
        if (url == null) {
            String dbType = System.getProperty("datasource.dbType");
            url = System.getProperty("datasource.url.db." + dbType.toLowerCase());
        }
        return url;
    }

    protected DataSourceManager() {
    }

    public static void setInstance(DataSourceManager mock) {
        instance = mock != null ? mock : DEFAULT_INSTANCE;
    }

    public static DataSourceManager instance() {
        return instance;
    }

    public DataSource createDataSource(String dsName, String driverClass, String url, String username, String password, int minPoolSize, int maxPoolSize, Properties props) throws Exception {
        return this.createDataSource(dsName, driverClass, url, username, password, minPoolSize, maxPoolSize, Integer.valueOf(DEFAULT_MAX_ACTIVE_TIME), props);
    }

    public DataSource createDataSource(String dsName, String driverClass, String url, String username, String password, int minPoolSize, int maxPoolSize, int maxActiveTime, Properties props) throws Exception {
        DataSource ds = DAO.createDataSource(dsName, driverClass, url, username, password, minPoolSize, maxPoolSize, maxActiveTime, props);
        props.setProperty(CONFIG_DRIVER, driverClass);
        props.setProperty(CONFIG_URL, url);
        props.setProperty(CONFIG_USERNAME, username);
        props.setProperty(CONFIG_MIN_POOL_SIZE, String.valueOf(minPoolSize));
        props.setProperty(CONFIG_MAX_POOL_SIZE, String.valueOf(maxPoolSize));
        props.setProperty(CONFIG_MAX_ACTIVE_TIME, String.valueOf(maxActiveTime));
        this.dsMap.put(dsName, new DataSourceHolder(ds, props));
        return ds;
    }

    public DataSource createDataSource(String dsName, String driverClass, String url, String username, String password, int minPoolSize, int maxPoolSize) throws Exception {
        return this.createDataSource(dsName, driverClass, url, username, password, minPoolSize, maxPoolSize, new Properties());
    }

    public DataSource createDataSource(String dsName) throws Exception {
        DataSourceHolder dsHolder = this.dsMap.get(dsName);
        if (dsHolder != null) {
            ++dsHolder.owners;
            return dsHolder.ds;
        }
        File config = this.getConfigFile(dsName);
        Properties prop = new Properties();
        if (FileUtil.checkReadFile(config)) {
            prop.load(config.toURI().toURL().openStream());
        }
        String driver = prop.getProperty(CONFIG_DRIVER, DEFAULT_DRIVER);
        prop.remove(CONFIG_DRIVER);
        String url = prop.getProperty(CONFIG_URL);
        prop.remove(CONFIG_URL);
        String username = prop.getProperty(CONFIG_USERNAME);
        prop.remove(CONFIG_USERNAME);
        String password = prop.getProperty(CONFIG_PASSWORD);
        password = password == null ? null : ResUtil.decrypt(password, "iMAP");
        prop.remove(CONFIG_PASSWORD);
        String minPoolSize = prop.getProperty(CONFIG_MIN_POOL_SIZE, DEFAULT_MIN_POOL_SIZE);
        prop.remove(CONFIG_MIN_POOL_SIZE);
        String maxPoolSize = prop.getProperty(CONFIG_MAX_POOL_SIZE, DEFAULT_MAX_POOL_SIZE);
        prop.remove(CONFIG_MAX_POOL_SIZE);
        String maxActiveTime = prop.getProperty(CONFIG_MAX_ACTIVE_TIME, DEFAULT_MAX_ACTIVE_TIME);
        prop.remove(CONFIG_MAX_ACTIVE_TIME);
        String dbInfo = prop.getProperty(CONFIG_DBINFO);
        Vector<String> settingConfig = new Vector<String>();
        boolean result = this.getSettingDBInfo(dbInfo, settingConfig);
        if (result) {
            url = (String)settingConfig.get(0);
            username = (String)settingConfig.get(1);
            password = (String)settingConfig.get(2);
        } else {
            log.error((Object)"setting can not use.");
            url = url == null ? this.getDBURL(DEFAULT_URL, DEFAULT_IPADDRESS, DEFAULT_DBPORT, dbInfo) : url;
            username = username == null ? DEFAULT_USERNAME : username;
            password = password == null ? ResUtil.decrypt(DEFAULT_PASSWORD, "iMAP") : password;
            password = password == null ? "" : password;
        }
        log.warn((Object)(dsName + ";" + driver + ";" + url + ";" + username + ";" + minPoolSize + ";" + maxPoolSize + ";" + maxActiveTime + ";" + prop));
        return this.createDataSource(dsName, driver, url, username, password, Integer.valueOf(minPoolSize), Integer.valueOf(maxPoolSize), Integer.valueOf(maxActiveTime), prop);
    }

    public String getDbName(String url) {
        String dbName = null;
        String[] urlArray = url.split(":");
        if (urlArray[1].equalsIgnoreCase("sybase")) {
            dbName = url.split("/")[1];
        } else if (urlArray[1].equalsIgnoreCase("oracle")) {
            dbName = urlArray[5];
        } else if (urlArray[1].equalsIgnoreCase("sqlserver")) {
            dbName = url.split("=")[1];
        } else if (urlArray[1].equalsIgnoreCase("db2")) {
            dbName = urlArray[4].split("/")[1];
        }
        return dbName;
    }

    private boolean isOracle(String url) {
        return url == null ? false : url.indexOf("oracle") >= 0;
    }

    private String getDBURL(String url, String dbServerAddress, String dbPort, String dbInfo) {
        if (this.isOracle(url)) {
            dbInfo = DEFAULT_DBSERVERNAME;
        }
        ExtendProperties extendProperties = new ExtendProperties();
        extendProperties.setProperty("datasource.url", url);
        extendProperties.setProperty("datasource.dbServerIP", dbServerAddress);
        extendProperties.setProperty("datasource.dbServerPort", dbPort);
        extendProperties.setProperty("datasource.dbInfo", dbInfo);
        return extendProperties.getProperty("datasource.url");
    }

    private boolean getSettingDBInfo(String dbInfo, List<String> config) {
        try {
            String dbServerIP = ConfigTool.getConfigTool().getDBServerIPByServiceName(dbInfo);
            String dbPort = ConfigTool.getConfigTool().getDBServerPortByServiceName(dbInfo);
            String userName = ConfigTool.getConfigTool().getDBUserByDBName(dbInfo);
            String password = ConfigTool.getConfigTool().getDBPasswordByDBName(dbInfo);
            password = password == null ? "" : password;
            String url = this.getDBURL(DEFAULT_URL, dbServerIP, dbPort, dbInfo);
            config.clear();
            config.add(url);
            config.add(userName);
            config.add(password);
            if (log.isInfoEnabled()) {
                log.info((Object)("getSettingDBInfo dbInfo=" + dbInfo + ";dbServerIp=" + dbServerIP + ";dbPort=" + dbPort + ";userName=" + userName));
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)("dbInfo=" + dbInfo), (Throwable)e);
            return false;
        }
    }

    public void closeDataSource(String dsName) throws Exception {
        DataSourceHolder dsHolder = this.dsMap.get(dsName);
        if (dsHolder == null) {
            return;
        }
        --dsHolder.owners;
        if (dsHolder.owners == 0) {
            this.dsMap.remove(dsName);
            DAO.closeDataSource(dsHolder.ds);
        }
    }

    protected File getConfigFile(String dsName) throws Exception {
        File parent = Framework.getConfigDir();
        String configFilename = dsName;
        if (!configFilename.endsWith(CONFIG_EXT_NAME)) {
            configFilename = configFilename + CONFIG_EXT_NAME;
        }
        return new File(parent, configFilename);
    }

    public DataSource getDataSource(String dsName) {
        DataSourceHolder holder = this.dsMap.get(dsName);
        if (holder == null) {
            return null;
        }
        return holder.ds;
    }

    public Properties getProperties(String dsName) {
        DataSourceHolder holder = this.dsMap.get(dsName);
        if (holder != null) {
            return holder.properties;
        }
        return null;
    }

    public Connection getConnection(String dsName) throws Exception {
        DataSource ds = this.getDataSource(dsName);
        if (ds != null) {
            return ds.getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistTable(String dataSource, String table) throws Exception {
        Connection conn = null;
        try {
            conn = this.getConnection(dataSource);
            SqlManager sqlManager = SqlManagerFactory.instance().createSqlManager(conn);
            if (sqlManager instanceof DB2ServerManager) {
                String schema = this.getProperties(dataSource).getProperty("currentSchema");
                ((DB2ServerManager)sqlManager).setCurrentSchema(schema);
            }
            boolean bl = sqlManager.isExistTalbe(conn, table);
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTables(String dataSource, String pattern) throws Exception {
        Connection conn = null;
        try {
            conn = this.getConnection(dataSource);
            SqlManager sqlManager = SqlManagerFactory.instance().createSqlManager(conn);
            if (sqlManager instanceof DB2ServerManager) {
                ((DB2ServerManager)sqlManager).setCurrentSchema(this.getProperties(dataSource).getProperty("currentSchema"));
            }
            List<String> list = sqlManager.getTables(conn, pattern);
            return list;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    public void cleanup() throws Exception {
        for (DataSourceHolder dsHolder : this.dsMap.values()) {
            DAO.closeDataSource(dsHolder.ds);
        }
        this.dsMap.clear();
    }

    public long getConnectionCount() {
        long count = 0L;
        for (String ds : this.dsMap.keySet()) {
            try {
                SnapshotIF snapshot = ProxoolFacade.getSnapshot((String)ds);
                count += snapshot.getConnectionCount();
            }
            catch (ProxoolException e) {}
        }
        return count;
    }

    public int getActiveConnectionCount() {
        int count = 0;
        for (String ds : this.dsMap.keySet()) {
            try {
                SnapshotIF snapshot = ProxoolFacade.getSnapshot((String)ds);
                count += snapshot.getActiveConnectionCount();
            }
            catch (ProxoolException e) {}
        }
        return count;
    }

    public void addDataSource(String name, DataSource ds) {
        this.dsMap.put(name, new DataSourceHolder(ds, null));
    }

    static {
        instance = DEFAULT_INSTANCE = new DataSourceManager();
    }
}

