/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.dao;

import com.swimap.base.framework.dao.DaoFactory;
import com.swimap.base.framework.dao.PoolDataSource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class DAO {
    private static DaoFactory factory = null;
    private Connection conn;

    public static void setFactory(DaoFactory factory) {
        DAO.factory = factory;
    }

    private DAO(Connection conn) {
        this.conn = conn;
    }

    protected DAO() {
    }

    public static DAO create(Connection conn) {
        if (factory != null) {
            return factory.create(conn);
        }
        return new DAO(conn);
    }

    public ResultSet call(String sql, Object ... args) throws Exception {
        CallableStatement s = this.conn.prepareCall(sql);
        int i = 0;
        for (Object arg : args) {
            s.setObject(++i, arg);
        }
        return s.executeQuery();
    }

    public Statement mcall(String sql, Object ... args) throws Exception {
        CallableStatement s = this.conn.prepareCall(sql);
        int i = 0;
        for (Object arg : args) {
            s.setObject(++i, arg);
        }
        s.executeQuery();
        return s;
    }

    public ResultSet query(String sql, Object ... args) throws Exception {
        PreparedStatement s = this.conn.prepareStatement(sql);
        int i = 0;
        for (Object arg : args) {
            s.setObject(++i, arg);
        }
        return s.executeQuery();
    }

    public int execute(String sql, Object ... args) throws Exception {
        PreparedStatement s = this.conn.prepareStatement(sql);
        int i = 0;
        for (Object arg : args) {
            s.setObject(++i, arg);
        }
        return s.executeUpdate();
    }

    public PreparedStatement prepareInStatement(String sql, int count) throws Exception {
        int index = sql.indexOf("$");
        if (index == -1) {
            return this.conn.prepareStatement(sql);
        }
        StringBuilder sb = new StringBuilder(sql.substring(0, index));
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('?');
        }
        sb.append(sql.substring(index + 1));
        return this.conn.prepareStatement(sb.toString());
    }

    private static String getTestSQL(String url) {
        String testSQL = null;
        testSQL = url.toLowerCase().contains("oracle") ? "select 1 from dual" : "SELECT 1";
        return testSQL;
    }

    static DataSource createDataSource(String name, String driverClass, String url, String username, String password, int minPoolSize, int maxPoolSize, int maxActiveTime, Properties properties) throws Exception {
        Class.forName("org.logicalcobwebs.proxool.ProxoolDriver");
        Properties info = new Properties();
        info.setProperty("proxool.maximum-connection-count", String.valueOf(maxPoolSize));
        info.setProperty("proxool.minimum-connection-count", String.valueOf(minPoolSize));
        info.setProperty("proxool.maximum-active-time", String.valueOf(maxActiveTime));
        String testSQL = DAO.getTestSQL(url);
        info.setProperty("proxool.house-keeping-test-sql", testSQL);
        info.setProperty("proxool.test-before-use", "true");
        info.setProperty("proxool.test-after-use", "false");
        info.setProperty("user", username);
        info.setProperty("password", password);
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                info.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        String poolUrl = "proxool." + name + ':' + driverClass + ':' + url;
        ProxoolFacade.registerConnectionPool((String)poolUrl, (Properties)info);
        PoolDataSource poolDataSource = new PoolDataSource(name);
        poolDataSource.setDBInfo(properties.getProperty("dbInfo"));
        return poolDataSource;
    }

    static void closeDataSource(DataSource ds) throws Exception {
        if (ds instanceof PoolDataSource) {
            ProxoolFacade.removeConnectionPool((String)((PoolDataSource)ds).getName());
        }
    }
}

