/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.cache;

import com.swimap.base.framework.cache.Cache;
import com.swimap.base.framework.cache.CacheDataLoader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class WeakCache<K, V>
implements Cache<K, V> {
    private CacheDataLoader<K, V> loader;
    private Map<K, WeakReference<V>> data = new ConcurrentHashMap<K, WeakReference<V>>();

    WeakCache(CacheDataLoader<K, V> loader) {
        if (loader == null) {
            throw new IllegalArgumentException("Null CacheDataLoader");
        }
        this.loader = loader;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    private V getValue(K key) {
        WeakReference<V> ref = this.data.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V get(K key) {
        if (key == null) {
            return null;
        }
        V value = this.getValue(key);
        if (value == null) {
            value = this.loader.load(key);
            this.put(key, value);
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        if (key != null && value != null) {
            this.data.put(key, new WeakReference<V>(value));
        }
    }

    @Override
    public V remove(K key) {
        if (key == null) {
            return null;
        }
        WeakReference<V> ref = this.data.remove(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public void getAll(Collection<K> keys, Map<K, V> result) {
        ArrayList<K> missingKeys = new ArrayList<K>();
        for (K key : keys) {
            V value = this.getValue(key);
            if (value != null) {
                result.put(key, value);
                continue;
            }
            missingKeys.add(key);
        }
        if (missingKeys.size() > 0) {
            HashMap loaded = new HashMap();
            this.loader.loadAll(missingKeys, loaded);
            result.putAll(loaded);
            this.putAll(loaded);
        }
    }

    @Override
    public void putAll(Map<K, V> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        for (Map.Entry<K, V> entry : entrySet) {
            this.data.put(entry.getKey(), new WeakReference<V>(entry.getValue()));
        }
    }

    @Override
    public Collection<V> removeAll(Collection<K> keys) {
        ArrayList<V> removed = new ArrayList<V>(keys.size());
        for (K key : keys) {
            V value = this.remove(key);
            if (value == null) continue;
            removed.add(value);
        }
        return removed;
    }
}

