/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.cache;

import com.swimap.base.framework.cache.Cache;
import com.swimap.base.framework.cache.CacheDataLoader;
import com.swimap.base.framework.cache.CacheDataStore;
import com.swimap.base.framework.cache.StoreCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

class TwoLevelCache<K, V>
implements Cache<K, V> {
    private Cache<K, V> storeCache;
    private int memoryCacheSize;
    private Map<K, V> memoryCache = new ConcurrentHashMap();
    private Queue<K> queue = new ConcurrentLinkedQueue<K>();

    TwoLevelCache(CacheDataStore<K, V> store, CacheDataLoader<K, V> loader, int memoryCacheSize) {
        if (store == null) {
            throw new IllegalArgumentException("Null CacheDataStore");
        }
        if (loader == null) {
            throw new IllegalArgumentException("Null CacheDataLoader");
        }
        this.memoryCacheSize = memoryCacheSize;
        this.storeCache = new StoreCache<K, V>(store, loader);
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.memoryCache.clear();
        this.storeCache.clear();
    }

    @Override
    public V get(K key) {
        if (key == null) {
            return null;
        }
        V value = this.memoryCache.get(key);
        if (value == null) {
            value = this.storeCache.get(key);
            this.putData(key, value, false);
        } else {
            this.queue.remove(key);
            this.queue.add(key);
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        this.putData(key, value, true);
    }

    private void putData(K key, V value, boolean saveStore) {
        if (key == null || value == null) {
            return;
        }
        this.memoryCache.put(key, value);
        this.queue.add(key);
        if (saveStore) {
            this.storeCache.put(key, value);
        }
        if (this.memoryCache.size() > this.memoryCacheSize) {
            K oldestKey = this.queue.poll();
            this.memoryCache.remove(oldestKey);
        }
    }

    @Override
    public V remove(K key) {
        if (key == null) {
            return null;
        }
        this.queue.remove(key);
        V memoryValue = this.memoryCache.remove(key);
        V storevalue = this.storeCache.remove(key);
        if (memoryValue != null) {
            return memoryValue;
        }
        if (storevalue != null) {
            return storevalue;
        }
        return null;
    }

    @Override
    public void getAll(Collection<K> keys, Map<K, V> result) {
        ArrayList<K> missingKeys = new ArrayList<K>();
        for (K key : keys) {
            V value = this.memoryCache.get(key);
            if (value != null) {
                result.put(key, value);
                this.queue.remove(key);
                this.queue.add(key);
                continue;
            }
            missingKeys.add(key);
        }
        if (missingKeys.size() > 0) {
            HashMap loaded = new HashMap();
            this.storeCache.getAll(missingKeys, loaded);
            result.putAll(loaded);
            this.putAllData(loaded, false);
        }
    }

    @Override
    public void putAll(Map<K, V> map) {
        this.putAllData(map, true);
    }

    private void putAllData(Map<K, V> map, boolean saveStore) {
        if (map == null || map.size() == 0) {
            return;
        }
        this.memoryCache.putAll(map);
        this.queue.addAll(map.keySet());
        while (this.memoryCache.size() > this.memoryCacheSize) {
            K oldestKey = this.queue.poll();
            this.memoryCache.remove(oldestKey);
        }
        if (saveStore) {
            this.storeCache.putAll(map);
        }
    }

    @Override
    public Collection<V> removeAll(Collection<K> keys) {
        for (K key : keys) {
            this.queue.remove(key);
            this.memoryCache.remove(key);
        }
        ArrayList<V> removed = new ArrayList<V>();
        removed.addAll(this.storeCache.removeAll(keys));
        return removed;
    }
}

