/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.cache;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class StringWeakCache {
    private String name;
    private static Map<String, StringWeakCache> caches = new HashMap<String, StringWeakCache>();
    private Map<String, WeakReference<String>> stringBuf = new WeakHashMap<String, WeakReference<String>>();

    public static synchronized StringWeakCache newInstance(String name) {
        if (caches.containsKey(name)) {
            return caches.get(name);
        }
        StringWeakCache cache = new StringWeakCache(name);
        caches.put(name, cache);
        return cache;
    }

    public static synchronized void removeInstance(String name) {
        caches.remove(name);
    }

    private StringWeakCache(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String value) {
        if (null == value || value.trim().isEmpty()) {
            return "";
        }
        WeakReference<String> result = null;
        Map<String, WeakReference<String>> map = this.stringBuf;
        synchronized (map) {
            result = this.stringBuf.get(value);
            if (null == result) {
                result = new WeakReference<String>(value);
                this.stringBuf.put(value, result);
            }
        }
        return (String)result.get();
    }
}

