/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.cache;

import com.swimap.base.framework.cache.Cache;
import com.swimap.base.framework.cache.CacheDataLoader;
import com.swimap.base.framework.cache.CacheDataStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StoreCache<K, V>
implements Cache<K, V> {
    private static Log log = LogFactory.getLog(StoreCache.class);
    private CacheDataLoader<K, V> loader;
    private CacheDataStore<K, V> store;
    private boolean storeReady;

    StoreCache(CacheDataStore<K, V> store, CacheDataLoader<K, V> loader) {
        if (store == null) {
            throw new IllegalArgumentException("Null CacheDataStore");
        }
        if (loader == null) {
            throw new IllegalArgumentException("Null CacheDataLoader");
        }
        this.storeReady = false;
        this.store = store;
        this.loader = loader;
    }

    @Override
    public void clear() {
        if (this.storeReady) {
            try {
                this.store.clear();
            }
            catch (Exception e) {
                log.warn((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public V get(K key) {
        if (key == null) {
            return null;
        }
        Object value = null;
        if (this.storeReady) {
            try {
                value = this.store.load(key);
            }
            catch (Exception e) {
                log.warn((Object)("store.load:" + key), (Throwable)e);
                value = null;
            }
        }
        if (value == null) {
            value = this.loader.load(key);
            this.put(key, value);
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        if (key == null || value == null) {
            return;
        }
        if (!this.storeReady) {
            this.initStore();
        }
        try {
            this.store.save(key, value);
        }
        catch (Exception e) {
            log.warn((Object)("store.save:" + key), (Throwable)e);
        }
    }

    private synchronized void initStore() {
        if (!this.storeReady) {
            try {
                this.store.init();
                this.storeReady = true;
            }
            catch (Exception e) {
                log.warn((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public V remove(K key) {
        if (this.storeReady) {
            try {
                return this.store.remove(key);
            }
            catch (Exception e) {
                log.warn((Object)("store.remove:" + key), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void getAll(Collection<K> keys, Map<K, V> result) {
        ArrayList<K> missingKeys = new ArrayList<K>();
        try {
            if (this.storeReady) {
                this.store.loadAll(keys, result);
            }
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
        }
        for (K key : keys) {
            if (result.containsKey(key)) continue;
            missingKeys.add(key);
        }
        if (missingKeys.size() > 0) {
            HashMap loaded = new HashMap();
            this.loader.loadAll(missingKeys, loaded);
            result.putAll(loaded);
            this.putAll(loaded);
        }
    }

    @Override
    public void putAll(Map<K, V> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        if (!this.storeReady) {
            this.initStore();
        }
        try {
            this.store.saveAll(map);
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
        }
    }

    @Override
    public Collection<V> removeAll(Collection<K> keys) {
        if (this.storeReady) {
            try {
                Collection<V> removed = this.store.removeAll(keys);
                if (removed != null) {
                    return removed;
                }
            }
            catch (Exception e) {
                log.warn((Object)"", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }
}

