/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.cache;

import com.swimap.base.framework.cache.Cache;
import com.swimap.base.framework.cache.CacheDataLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

class LruCache<K, V>
implements Cache<K, V> {
    private int size;
    private CacheDataLoader<K, V> loader;
    private Map<K, V> data = new ConcurrentHashMap();
    private Queue<K> queue = new ConcurrentLinkedQueue<K>();

    LruCache(CacheDataLoader<K, V> loader, int size) {
        if (loader == null) {
            throw new IllegalArgumentException("Null CacheDataLoader");
        }
        this.loader = loader;
        this.size = size;
    }

    @Override
    public void clear() {
        this.data.clear();
        this.queue.clear();
    }

    @Override
    public V get(K key) {
        if (key == null) {
            return null;
        }
        V value = this.data.get(key);
        if (value == null) {
            value = this.loader.load(key);
            this.put(key, value);
        } else {
            this.queue.remove(key);
            this.queue.add(key);
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        if (key == null || value == null) {
            return;
        }
        V v = this.data.put(key, value);
        if (v != null) {
            return;
        }
        this.queue.add(key);
        if (this.data.size() > this.size) {
            K oldestKey = this.queue.poll();
            this.data.remove(oldestKey);
        }
    }

    @Override
    public V remove(K key) {
        if (key == null) {
            return null;
        }
        this.queue.remove(key);
        return this.data.remove(key);
    }

    @Override
    public void getAll(Collection<K> keys, Map<K, V> result) {
        ArrayList<K> missingKeys = new ArrayList<K>();
        for (K key : keys) {
            V value = this.data.get(key);
            if (value != null) {
                result.put(key, value);
                this.queue.remove(key);
                this.queue.add(key);
                continue;
            }
            missingKeys.add(key);
        }
        if (missingKeys.size() > 0) {
            HashMap loaded = new HashMap();
            this.loader.loadAll(missingKeys, loaded);
            result.putAll(loaded);
            this.putAll(loaded);
        }
    }

    @Override
    public void putAll(Map<K, V> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Collection<V> removeAll(Collection<K> keys) {
        ArrayList<V> removed = new ArrayList<V>(keys.size());
        for (K key : keys) {
            V value = this.remove(key);
            if (value == null) continue;
            removed.add(value);
        }
        return removed;
    }
}

