/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.cache;

import com.swimap.base.framework.cache.Cache;
import com.swimap.base.framework.cache.CacheDataLoader;
import com.swimap.base.framework.cache.CacheDataStore;
import com.swimap.base.framework.cache.FifoCache;
import com.swimap.base.framework.cache.LruCache;
import com.swimap.base.framework.cache.SoftCache;
import com.swimap.base.framework.cache.StaticCache;
import com.swimap.base.framework.cache.StoreCache;
import com.swimap.base.framework.cache.TwoLevelCache;
import com.swimap.base.framework.cache.WeakCache;

public abstract class CacheFactory {
    public static <K, V> Cache<K, V> createStaticCache(CacheDataLoader<K, V> loader) {
        return new StaticCache<K, V>(loader);
    }

    public static <K, V> Cache<K, V> createWeakCache(CacheDataLoader<K, V> loader) {
        return new WeakCache<K, V>(loader);
    }

    public static <K, V> Cache<K, V> createSoftCache(CacheDataLoader<K, V> loader) {
        return new SoftCache<K, V>(loader);
    }

    public static <K, V> Cache<K, V> createLruCache(CacheDataLoader<K, V> loader, int size) {
        return new LruCache<K, V>(loader, size);
    }

    public static <K, V> Cache<K, V> createFifoCache(CacheDataLoader<K, V> loader, int size) {
        return new FifoCache<K, V>(loader, size);
    }

    public static <K, V> Cache<K, V> createStoreCache(CacheDataStore<K, V> store, CacheDataLoader<K, V> loader) {
        return new StoreCache<K, V>(store, loader);
    }

    public static <K, V> Cache<K, V> createTwoLevelCache(CacheDataStore<K, V> store, CacheDataLoader<K, V> loader, int memoryCacheSize) {
        return new TwoLevelCache<K, V>(store, loader, memoryCacheSize);
    }
}

