/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework;

import com.swimap.base.framework.FrameInformationManager;
import com.swimap.base.framework.StopDsThread;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class UncaughtExceptionHandlerImpl
implements Thread.UncaughtExceptionHandler {
    private static Log log = LogFactory.getLog(UncaughtExceptionHandlerImpl.class);
    private static final String ExitForOOM = "ExitForOOM";

    UncaughtExceptionHandlerImpl() {
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof OutOfMemoryError && (System.getProperty(ExitForOOM) == null || Boolean.getBoolean(ExitForOOM))) {
            FrameInformationManager.getInstance().record("Ds out of memory", "Checking ds out of memory is found", false);
            StopDsThread stop = new StopDsThread("Stop_ds_by_OutOfMemory", 2000L);
            stop.start();
            log.error((Object)t.getName(), e);
        } else {
            log.error((Object)t.getName(), e);
        }
    }

    static String createPID() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        String jvm = bean.getName();
        String pid = null;
        try {
            pid = jvm.substring(0, jvm.indexOf("@"));
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
        }
        return pid;
    }
}

