/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework;

import com.swimap.base.framework.Activator;
import com.swimap.base.framework.BundleHolder;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatusInfoUtil {
    private static Log log = LogFactory.getLog(StatusInfoUtil.class);
    private static Activator frameworkActivator;
    private static boolean isStopping;
    public static final String IN_STARTING_PROCESS = "in starting process";

    public static int getThreadCount() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.getThreadCount();
    }

    public static long getHeapMemoryUsageUsed() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        return memoryMXBean.getHeapMemoryUsage().getUsed();
    }

    static void setFrameworkActivator(Activator activator) {
        frameworkActivator = activator;
    }

    public static List<String> getBundleNames() {
        ArrayList<String> bundleNames = new ArrayList<String>();
        if (frameworkActivator != null) {
            bundleNames.add("com.swimap.base.framework");
            for (BundleHolder holder : StatusInfoUtil.frameworkActivator.bundleList) {
                bundleNames.add(holder.bundleName);
            }
        }
        return bundleNames;
    }

    public static String getDSInstance() {
        return System.getProperty("imap.config");
    }

    public static long getStartTime() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        long startTime = runtimeMXBean.getStartTime();
        if (frameworkActivator != null) {
            if (StatusInfoUtil.frameworkActivator.upTime == 0L) {
                return 0L;
            }
            return StatusInfoUtil.frameworkActivator.upTime - startTime;
        }
        return 0L;
    }

    public static long getRunTime() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getUptime();
    }

    public static int getBundlesState() {
        if (frameworkActivator != null) {
            return StatusInfoUtil.frameworkActivator.bundlesState;
        }
        return 0;
    }

    public static boolean existsLoadBalance() {
        if (frameworkActivator != null) {
            return StatusInfoUtil.frameworkActivator.existsBalance;
        }
        return false;
    }

    public static boolean isFrameworkStopping() {
        return isStopping;
    }

    public static void setFrameworkStopping() {
        log.warn((Object)"Set the framework stopping status to true");
        isStopping = true;
    }

    public static void reload() {
        try {
            Activator.getInstance().reload();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    static {
        isStopping = false;
    }
}

