/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework;

import com.swimap.base.framework.ServerImpl;
import com.swimap.external.sf.ssl.ICipher;
import com.swimap.external.sf.ssl.SSLManager;
import com.swimap.serverutil.ServerUtility;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResUtil {
    private static Log log = LogFactory.getLog(ResUtil.class);
    private static String key = "iMAP";

    static Locale getDefaultLocale() {
        Locale currentLocale = null;
        try {
            Locale default_locale;
            String installLang = System.getProperty("imap.language");
            installLang = installLang == null ? "en_US" : installLang;
            String[] installLangs = installLang.split("_");
            String tempLanguage = installLangs[0];
            String tempCountry = installLangs[1];
            currentLocale = default_locale = new Locale("en", "US");
            if (tempLanguage != null && tempCountry != null) {
                currentLocale = new Locale(tempLanguage.toLowerCase(), tempCountry.toUpperCase());
            }
        }
        catch (Exception e) {
            log.error((Object)"getLocale error!", (Throwable)e);
            currentLocale = new Locale("en", "US");
        }
        Locale.setDefault(currentLocale);
        return currentLocale;
    }

    public static SSLContext getDefaultSSLContext() {
        String sslConfigFilePath = System.getProperty("imap.rpc.sslRoot");
        log.info((Object)("sslConfigFilePath:" + sslConfigFilePath));
        SSLContext sslContext = null;
        try {
            SSLManager manager = SSLManager.init((String)sslConfigFilePath, (int)1, (ICipher)new ServerImpl());
            System.setProperty("imap.ssl.encryptLevel", manager.getOption().getEncryptLevel());
            System.setProperty("imap.ssl.authPeer", String.valueOf(manager.getOption().isEnableAuthPeer()));
            System.setProperty("imap.ssl.loadDH", String.valueOf(manager.getOption().isLoadDH()));
            System.setProperty("imap.ssl.version", manager.getOption().getVersion());
            sslContext = manager.getSSLContext();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return sslContext;
    }

    public static String decrypt(String cipher) {
        return ResUtil.decrypt(cipher, key);
    }

    public static String decrypt(String cipher, String key) {
        if (cipher == null || "".equals(cipher)) {
            return "";
        }
        try {
            if (cipher.charAt(0) == '{' && cipher.charAt(cipher.length() - 1) == '}' && key.equals(ResUtil.key)) {
                String plain = cipher.substring(1, cipher.length() - 1);
                try {
                    return ServerUtility.decrypt_dynamicKey((String)plain);
                }
                catch (Exception e) {
                    return ServerUtility.decrypt_dynamicKey((String)plain);
                }
            }
            return cipher;
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
            return cipher;
        }
    }
}

