/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework;

import com.swimap.base.framework.LoadCheck;
import com.swimap.base.framework.ResUtil;
import com.swimap.base.framework.StopDsThread;
import java.io.File;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Framework {
    private static Log log = LogFactory.getLog(Framework.class);
    private static SSLContext context = null;
    public static final String loginEvent = "local.sm.login";
    public static final String logoutEvent = "local.sm.logout";
    public static String home = null;
    public static final String SYSTEM_PROPERTY_CONFIG_HOME = "ds.config.home";
    private static LoadCheck check = new LoadCheck();
    public static final String IMAPUSERNAME = "iMAPUserName";
    public static final String IMAPGROUPNAME = "iMAPGroupName";
    public static final String[] CMDS_CHOWN = new String[]{"/usr/bin/chown", "/bin/chown"};
    public static final String[] CMDS_CHGRP = new String[]{"/usr/bin/chgrp", "/bin/chgrp"};

    public static File getConfigDir() {
        String configHome = System.getProperty(SYSTEM_PROPERTY_CONFIG_HOME);
        if (configHome == null) {
            return new File(Framework.getHomeDir(), "cfg");
        }
        return new File(configHome);
    }

    public static String getHomeDir() {
        if (home == null) {
            home = System.getProperty("imap.home");
            if (home != null) {
                return home;
            }
            return ".";
        }
        return home;
    }

    public static File getBundleDir() {
        return new File(Framework.getHomeDir(), "bundles");
    }

    public static String getInstanceName() {
        return System.getProperty("imap.config");
    }

    public static Locale getLocale() {
        return ResUtil.getDefaultLocale();
    }

    public static SSLContext getSSLcontext() {
        if (context == null) {
            context = ResUtil.getDefaultSSLContext();
        }
        return context;
    }

    public static void setLoadCheck(LoadCheck _check) {
        if (_check == null) {
            log.error((Object)"Framework setLoadCheck check is null.");
            return;
        }
        check = _check;
    }

    public static boolean check(String symbolicName) {
        boolean result = check.check(symbolicName);
        log.warn((Object)("Framework | check | start to check." + symbolicName + " = " + result));
        return result;
    }

    public static LoadCheck getLoadCheck() {
        return check;
    }

    private static String getCommand(String[] cmds) {
        for (String cmd : cmds) {
            if (!new File(cmd).exists()) continue;
            return cmd;
        }
        return null;
    }

    public static void setFileRight(String fileName) {
    }

    public static void stopDS() {
        log.error((Object)"stopDS", (Throwable)new Exception());
        StopDsThread stopds = new StopDsThread("Stop_DS");
        stopds.start();
    }
}

