/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FrameInformationManager {
    private static Log log = LogFactory.getLog(FrameInformationManager.class);
    private static FrameInformationManager instance = new FrameInformationManager();
    private Map<String, Object> parameterMap = new ConcurrentHashMap<String, Object>();
    private Map<String, CheckResult> checkResultMap = new ConcurrentHashMap<String, CheckResult>();

    private FrameInformationManager() {
    }

    public static FrameInformationManager getInstance() {
        return instance;
    }

    public static void printInfo() {
        log.error((Object)FrameInformationManager.getInstance().toString());
        log.error((Object)"\n\n\n");
    }

    public void record(String key, Object value) {
        if (key != null && value != null) {
            this.parameterMap.put(key, value);
        }
    }

    public void record(String key, Object value, boolean isSuccess) {
        if (key != null && value != null) {
            CheckResult result = new CheckResult(isSuccess, value);
            this.checkResultMap.put(key, result);
        }
    }

    private static String getStartTime() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return new Date(runtimeMXBean.getStartTime()).toString();
    }

    public String toString() {
        return this.getInformation(this.parameterMap, this.checkResultMap);
    }

    String getInformation(Map<String, Object> parameterMap, Map<String, CheckResult> checkResultMap) {
        String value;
        String info = "\n";
        info = info + "[======================DS Start Information======================] " + FrameInformationManager.getStartTime() + "\n";
        for (String name : parameterMap.keySet()) {
            value = parameterMap.get(name).toString();
            info = info + name + this.getSeparetor(name) + value + "\n";
        }
        info = info + "[----------------------check item information--------------------]\n";
        if (checkResultMap.isEmpty()) {
            String all = "All check item";
            info = info + all + this.getSeparetor(all) + "------------------Passed\n";
        } else {
            for (String name : checkResultMap.keySet()) {
                value = checkResultMap.get(name).toString();
                info = info + "[" + name + "]" + this.getSeparetor(name) + value + "\n";
            }
        }
        info = info + "[======================DS End Information=========================]";
        return info;
    }

    private String getSeparetor(String name) {
        String sp = "";
        int j = 5 - name.length() / 8;
        for (int i = 0; i < j; ++i) {
            sp = sp + "\t";
        }
        return sp;
    }

    void clear() {
        this.parameterMap = new ConcurrentHashMap<String, Object>();
        this.checkResultMap = new ConcurrentHashMap<String, CheckResult>();
    }

    private static class CheckResult {
        protected boolean ok = false;
        protected Object desc = null;

        private CheckResult() {
            this.ok = true;
            this.desc = "--";
        }

        private CheckResult(boolean ok, Object desc) {
            this.ok = ok;
            this.desc = desc;
        }

        public String toString() {
            return this.desc.toString() + "------------------" + (this.ok ? "Passed" : "Failed");
        }
    }
}

