/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    public static final long READ_FILE_MAX_SIZE = 10L;
    private static Log log = LogFactory.getLog(FileUtil.class);

    private static boolean checkReadFileSize(File file, long size) {
        boolean result;
        long length = file.length() / 1024L / 1024L;
        boolean bl = result = length < size;
        if (!result && log.isInfoEnabled()) {
            log.info((Object)String.format("checkReadFileSize:%s size(%sM) bigger than %sM.", file.getAbsolutePath(), length, size));
        }
        return result;
    }

    public static boolean checkReadFile(String fileName) {
        if (fileName != null) {
            return FileUtil.checkReadFile(new File(fileName), 10L);
        }
        return false;
    }

    public static boolean checkReadFile(File file) {
        if (file != null) {
            return FileUtil.checkReadFile(file, 10L);
        }
        return false;
    }

    private static boolean checkReadFile(File file, long size) {
        String fileName = file.getAbsolutePath();
        if (!file.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("checkReadFile:%s is not existed.", fileName));
            }
            return false;
        }
        return FileUtil.checkReadFileSize(file, size);
    }

    public static List<String> readLines(String fileName) {
        return FileUtil.readLines(fileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(String fileName, boolean isConvert) {
        Vector<String> lines = new Vector<String>();
        if (fileName == null) {
            return lines;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(isConvert ? line.trim() : line);
            }
        }
        catch (Exception e) {
            try {
                log.warn((Object)e);
            }
            catch (Throwable throwable) {
                FileUtil.close(reader);
                throw throwable;
            }
            FileUtil.close(reader);
        }
        FileUtil.close(reader);
        return lines;
    }

    private static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
            reader = null;
        }
    }

    public static Properties loadProperties(String fileName) {
        if (fileName != null) {
            return FileUtil.loadProperties(new File(fileName));
        }
        return new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) {
        Properties properties = new Properties();
        if (FileUtil.checkReadFile(file)) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                properties.load(stream);
            }
            catch (Exception e) {
                try {
                    log.warn((Object)e);
                }
                catch (Throwable throwable) {
                    FileUtil.close(stream);
                    throw throwable;
                }
                FileUtil.close(stream);
            }
            FileUtil.close(stream);
        }
        return properties;
    }

    private static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
            stream = null;
        }
    }
}

