/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework;

import java.io.File;
import org.osgi.framework.Bundle;

class BundleHolder {
    public long bundleId;
    public String bundleName;
    public long lastModified;
    public File dir;

    BundleHolder(Bundle bundle) throws Exception {
        this.bundleId = bundle.getBundleId();
        this.bundleName = bundle.getSymbolicName();
        this.dir = new File(bundle.getLocation().substring(5));
        if (this.dir != null && "true".equals(System.getProperty("imap.framework.autoupdate"))) {
            this.lastModified = BundleHolder.getLastModified(this.dir);
        }
    }

    boolean checkModified() {
        long ts = BundleHolder.getLastModified(this.dir);
        if (ts > this.lastModified) {
            this.lastModified = ts;
            return true;
        }
        return false;
    }

    static long getLastModified(File root) {
        long lastModified = root.lastModified();
        if (root.isDirectory()) {
            File[] files;
            for (File file : files = root.listFiles()) {
                long ts = BundleHolder.getLastModified(file);
                if (ts <= lastModified) continue;
                lastModified = ts;
            }
        }
        return lastModified;
    }
}

