/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework;

import com.swimap.base.framework.BundleHolder;
import com.swimap.base.framework.CommandProviderEx;
import com.swimap.base.framework.FileUtil;
import com.swimap.base.framework.FrameInformationManager;
import com.swimap.base.framework.Framework;
import com.swimap.base.framework.StatusInfoUtil;
import com.swimap.base.framework.UncaughtExceptionHandlerImpl;
import com.swimap.base.framework.watchdog.WatchDog;
import com.swimap.base.sysconfigure.ConfigTool;
import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
extends TimerTask
implements BundleActivator {
    private static Log log = LogFactory.getLog(Activator.class);
    private static final String CONFIG_EXT_NAME = ".instance";
    private static final String PROPERTY_CONFIG = "imap.config";
    private static final String PROPERTY_BASEFILE = "basefile";
    private static final String PROPERTY_BUNDLES = "imap.bundles";
    private static final String PROPERTY_BUNDLELIST = "imap.bundlelist.directory";
    public static final String PROPERTY_AUTO_UPDATE = "imap.framework.autoupdate";
    private static final String REQUIRE_BUNDLE = "Require-Bundle";
    private static final int AUTO_UPDATE_INTERVAL = 3000;
    protected List<BundleHolder> bundleList = new ArrayList<BundleHolder>();
    protected long upTime = 0L;
    protected int bundlesState = 0;
    protected boolean existsBalance = false;
    protected Timer autoUpdateTimer;
    protected BundleContext context;
    private HashSet<String> bundleSet = new HashSet();
    private static Activator instance = null;
    private List<Bundle> installedBundles = null;
    private List<String> configuredBundlesList = new ArrayList<String>(16);
    private WatchDog dog;
    public static final String FrameParameter_VM = "JVM infomation";
    public static final String InstanceFileStorageCheck = "Instance file storage";
    public static final String InstanceFileSizeCheck = "Instance file size";
    public static final String ConfigFileStorageCheck = "Config file storage";
    private static final String DS_INSTANCE_PROPERTYKEY_URL_EM_USE_BY_DS = "imap.rpc.em";
    private static final String DS_INSTANCE_PROPERTYKEY_URL_MRB_USE_BY_DS = "imap.rpc.mdp";
    private static final String DS_INSTANCE_PROPERTYKEY_URL_EM_USE_BY_CLIENT = "imap.url.em";
    private static final String DS_INSTANCE_PROPERTYKEY_URL_MRB_USE_BY_CLIENT = "imap.url.mrb";
    private static final int DEFAULT_MDP_PORT = 31030;
    private static final int DEFAULT_MDP_SSL_PORT = 31080;
    private static final int DEFAULT_MDP_TRUST_PORT = 31095;
    private static final int DEFAULT_EM_PORT = 31032;
    private static final int DEFAULT_EM_SSL_PORT = 31082;
    private static final int DEFAULT_EM_TRUST_PORT = 31096;
    private static final String KEY_MDP_PORT = "MDPPort";
    private static final String KEY_MDP_SSL_PORT = "MDPSSLPort";
    private static final String KEY_MDP_TRUST_PORT = "MDPTrustPort";
    private static final String KEY_EM_PORT = "listen_port";
    private static final String KEY_EM_SSL_PORT = "ssl_port";
    private static final String KEY_EM_TRUST_PORT = "trust_port";
    private static final String SETTING_CFG_PATH = "settingcfgpath";
    private static final String IMAP_CFG_PATH = "imapcfgpath";

    public static Activator getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        FrameInformationManager.getInstance().record(FrameParameter_VM, Arrays.toString(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray()));
        this.installedBundles = new ArrayList<Bundle>();
        System.setProperty("in starting process", "true");
        ProxoolFacade.disableShutdownHook();
        instance = this;
        this.context = context;
        log.warn((Object)"framework started!");
        this.setConsoleRight();
        Properties prop = this.getConfigProperties();
        if (prop != null) {
            String bundleListPath;
            this.addSystemProperties(prop);
            if ("true".equals(System.getProperty("imap.exception.uncaught", "true"))) {
                UncaughtExceptionHandlerImpl exceptionHandler = new UncaughtExceptionHandlerImpl();
                Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
            }
            Framework.getLocale();
            String bundles = prop.getProperty(PROPERTY_BUNDLES);
            if (bundles != null) {
                String[] bundleNames = bundles.split(",");
                this.startBundles(bundleNames);
            }
            if (null != (bundleListPath = prop.getProperty(PROPERTY_BUNDLELIST)) && bundleListPath.length() > 0) {
                this.startOtherConfiguredBundles(bundleListPath.trim());
            }
            context.registerService("com.swimap.base.framework.Framework", (Object)new Framework(), null);
            String autoUpdate = prop.getProperty(PROPERTY_AUTO_UPDATE);
            if ("true".equals(autoUpdate)) {
                this.autoUpdateTimer = new Timer();
                this.autoUpdateTimer.schedule((TimerTask)this, 3000L, 3000L);
            }
            String homeDirName = System.getProperty("imap.home");
            File instanceDir = new File(new File(new File(homeDirName), "var"), System.getProperty(PROPERTY_CONFIG));
            Framework.setFileRight(instanceDir.getAbsolutePath());
            File bootDir = new File(new File(new File(homeDirName), "lib"), "boot");
            Framework.setFileRight(bootDir.getAbsolutePath());
            this.upTime = System.currentTimeMillis();
            StatusInfoUtil.setFrameworkActivator(this);
            this.dog = new WatchDog();
            this.dog.start();
            context.registerService(CommandProvider.class.getName(), (Object)new CommandProviderEx(), null);
        } else {
            log.error((Object)"imap config file not found! , while setting server is disable.");
            FrameInformationManager.getInstance().record(InstanceFileStorageCheck, "Checking instance file is config.", false);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            FrameInformationManager.printInfo();
            System.exit(-1);
        }
        System.setProperty("in starting process", "false");
    }

    private void startOtherConfiguredBundles(String bundleListPath) {
        List<String> instanceBundleFiles = this.getOrderedBundleFiles(bundleListPath);
        for (String tempFile : instanceBundleFiles) {
            log.info((Object)("Load bundle file:--- " + tempFile));
            Properties prop = FileUtil.loadProperties(new File(bundleListPath + File.separator + tempFile));
            String bundleString = prop.getProperty(PROPERTY_BUNDLES);
            log.info((Object)("Bundles configured in file:--" + bundleString));
            if (null == bundleString || bundleString.trim().equals("")) continue;
            String[] bundles = bundleString.split(",");
            try {
                this.startBundles(bundles);
                log.info((Object)("Start bundles configured in file completed. File = " + tempFile));
            }
            catch (Exception e) {
                log.error((Object)("Error while starting the bundles" + e));
            }
        }
    }

    private List<String> getOrderedBundleFiles(String bundleListPath) {
        File parent = new File(bundleListPath);
        String[] files = parent.list();
        ArrayList<String> bundleFiles = new ArrayList<String>();
        if (null != files) {
            for (String file : files) {
                if (!file.endsWith(".bundlelist") || !file.contains("_")) continue;
                String temp = file.substring(0, file.indexOf("_"));
                try {
                    Integer.parseInt(temp);
                    bundleFiles.add(file);
                }
                catch (NumberFormatException ne) {
                    log.error((Object)("Number format exception while parsing file:- " + file));
                }
            }
        }
        Collections.sort(bundleFiles, new BundleListComparator());
        return bundleFiles;
    }

    private void setConsoleRight() {
        try {
            File var = new File(new URL(System.getProperty("osgi.configuration.area")).getFile());
            File consoleportFile = new File(var, "consoleport");
            Framework.setFileRight(consoleportFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    private Properties getConfigProperties() throws Exception {
        File configFile = this.getConfigFile();
        log.info((Object)("instance file" + configFile.getPath()));
        if (!FileUtil.checkReadFile(configFile)) {
            log.error((Object)String.format("Check instance file(%s) failed. System will exit.", configFile));
            System.exit(0);
        }
        Properties props = FileUtil.loadProperties(configFile);
        try {
            this.handleIp(props);
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
        }
        return props;
    }

    private static String modifyProtrolAddress(Properties properties, String propertyKey, String protocol, String newAddress) {
        String newProtocol = "";
        StringTokenizer st = new StringTokenizer(protocol, ";");
        while (st.hasMoreTokens()) {
            String protocolPre;
            String tmpProtocol = st.nextToken();
            if (tmpProtocol.indexOf(protocolPre = "://") > 0) {
                String protocolHead = tmpProtocol.substring(0, tmpProtocol.indexOf(protocolPre) + protocolPre.length());
                String protocolPort = tmpProtocol.substring(tmpProtocol.lastIndexOf(":"), tmpProtocol.length());
                tmpProtocol = protocolHead + newAddress + protocolPort;
                newProtocol = newProtocol + tmpProtocol + ";";
                continue;
            }
            String protocolPort = tmpProtocol.substring(tmpProtocol.lastIndexOf(":"), tmpProtocol.length());
            newProtocol = "corbaloc:iiop:" + newAddress + protocolPort + ";";
        }
        newProtocol = newProtocol.substring(0, newProtocol.length() - 1);
        return Activator.replaceMRBAndEMport(properties, propertyKey, newProtocol);
    }

    private static String replaceMRBAndEMport(Properties properties, String propertyKey, String protocol) {
        try {
            if (DS_INSTANCE_PROPERTYKEY_URL_EM_USE_BY_CLIENT.equals(propertyKey)) {
                int emPort = Activator.getEMPort();
                protocol = protocol.replace("31032", String.valueOf(emPort));
                int emSSLPort = Activator.getEMSSLPort();
                protocol = protocol.replace("31082", String.valueOf(emSSLPort));
            }
            if (DS_INSTANCE_PROPERTYKEY_URL_MRB_USE_BY_CLIENT.equals(propertyKey)) {
                int mrbPort = Activator.getMRBPort();
                protocol = protocol.replace("31030", String.valueOf(mrbPort));
                int mrbSSLPort = Activator.getMRBSSLPort();
                protocol = protocol.replace("31080", String.valueOf(mrbSSLPort));
            }
            if (DS_INSTANCE_PROPERTYKEY_URL_EM_USE_BY_DS.equals(propertyKey)) {
                int emTrustPort = Activator.getEMTrustPort();
                protocol = protocol.replace("31032", String.valueOf(emTrustPort));
            }
            if (DS_INSTANCE_PROPERTYKEY_URL_MRB_USE_BY_DS.equals(propertyKey)) {
                int mrbTrustPort = Activator.getMRBTrustPort();
                protocol = protocol.replace("31030", String.valueOf(mrbTrustPort));
            }
            log.warn((Object)("propertyKey:" + propertyKey + ", protocol:" + protocol));
            return protocol;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return protocol;
        }
    }

    private static int getMRBPort() {
        String propertiesPath = System.getProperty(IMAP_CFG_PATH);
        return Activator.getPropertiesIntegerValue(propertiesPath, KEY_MDP_PORT, 31030);
    }

    private static int getMRBSSLPort() {
        String propertiesPath = System.getProperty(IMAP_CFG_PATH);
        return Activator.getPropertiesIntegerValue(propertiesPath, KEY_MDP_SSL_PORT, 31080);
    }

    private static int getMRBTrustPort() {
        String propertiesPath = System.getProperty(IMAP_CFG_PATH);
        return Activator.getPropertiesIntegerValue(propertiesPath, KEY_MDP_TRUST_PORT, 31095);
    }

    private static int getEMPort() {
        String properties = System.getProperty(SETTING_CFG_PATH);
        return Activator.getPropertiesIntegerValue(properties, KEY_EM_PORT, 31032);
    }

    private static int getEMSSLPort() {
        String properties = System.getProperty(SETTING_CFG_PATH);
        return Activator.getPropertiesIntegerValue(properties, KEY_EM_SSL_PORT, 31082);
    }

    private static int getEMTrustPort() {
        String properties = System.getProperty(SETTING_CFG_PATH);
        return Activator.getPropertiesIntegerValue(properties, KEY_EM_TRUST_PORT, 31096);
    }

    private static int getPropertiesIntegerValue(String propertiesPath, String key, int defaultValue) {
        try {
            File config = new File(propertiesPath);
            Properties properties = FileUtil.loadProperties(config);
            int intValue = Integer.valueOf(properties.getProperty(key));
            return intValue;
        }
        catch (Exception e) {
            log.error((Object)("Error config path=" + propertiesPath + ", value will use defaultValue=" + defaultValue), (Throwable)e);
            return defaultValue;
        }
    }

    private static void setProtocolAddress(Properties props, String property, String newAddress) {
        String protocol = props.getProperty(property);
        if (protocol != null) {
            protocol = Activator.modifyProtrolAddress(props, property, protocol, newAddress);
            props.setProperty(property, protocol);
        }
    }

    void handleIp(Properties props) throws Exception {
        String settingcfg = props.getProperty(SETTING_CFG_PATH);
        if (settingcfg == null) {
            log.error((Object)"settingcfgpath not set.");
            return;
        }
        System.setProperty(SETTING_CFG_PATH, settingcfg);
        String imapcfg = props.getProperty(IMAP_CFG_PATH);
        if (imapcfg != null) {
            System.setProperty(IMAP_CFG_PATH, imapcfg);
        } else {
            log.warn((Object)"imapcfgpath not set.");
        }
        String masterIp = ConfigTool.getConfigTool().getMasterIp();
        log.warn((Object)("masterIp:" + masterIp));
        if (masterIp != null) {
            String[] protocolProperties;
            for (String property : protocolProperties = new String[]{DS_INSTANCE_PROPERTYKEY_URL_EM_USE_BY_DS, DS_INSTANCE_PROPERTYKEY_URL_MRB_USE_BY_DS, "imap.rpc.orb.ns", DS_INSTANCE_PROPERTYKEY_URL_EM_USE_BY_CLIENT, DS_INSTANCE_PROPERTYKEY_URL_MRB_USE_BY_CLIENT, "imap.url.orb"}) {
                Activator.setProtocolAddress(props, property, masterIp);
            }
        }
    }

    protected void addSystemProperties(Properties prop) throws Exception {
        Properties sys = System.getProperties();
        sys.putAll((Map<?, ?>)prop);
        System.setProperties(sys);
    }

    protected void startBundles(String[] bundleNames) throws Exception {
        if (this.context == null) {
            return;
        }
        String home = Framework.getHomeDir();
        File bundleDir = new File(home, "bundles");
        long time = 0L;
        int bundleCount = 0;
        int localBundleCount = 0;
        ArrayList<Bundle> installedBundles = new ArrayList<Bundle>();
        for (String name : bundleNames) {
            ++localBundleCount;
            if (this.configuredBundlesList.contains(name)) {
                log.info((Object)("Duplicate bundle configured:- " + name));
                continue;
            }
            this.configuredBundlesList.add(name);
            String[] sname = name.trim().split("@");
            String bundleName = sname[0];
            try {
                File bundleLocation;
                if (log.isDebugEnabled()) {
                    time = System.currentTimeMillis();
                }
                if ((bundleLocation = new File(bundleDir, bundleName)).exists()) {
                    if ("com.swimap.base.loadbalance".equals(bundleName)) {
                        this.existsBalance = true;
                    }
                    if (sname.length > 1 && "optional".equals(sname[1])) {
                        this.bundleSet.add(sname[0]);
                    }
                    ++bundleCount;
                } else {
                    log.warn((Object)(bundleName + " doesn't exist, discard installing."));
                    continue;
                }
                Bundle bundle = this.installBundle(bundleLocation);
                installedBundles.add(bundle);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("install bundle: " + bundleName + " use " + (System.currentTimeMillis() - time) + " ms."));
            }
            catch (Exception e) {
                log.error((Object)("install bundle '" + bundleName + "' failed"), (Throwable)e);
                if (this.bundleSet.contains(bundleName)) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                FrameInformationManager.getInstance().record("Bundle install", String.format("Checking bundle(%s) install ", bundleName), false);
                FrameInformationManager.printInfo();
                System.exit(-1);
            }
        }
        this.installBundles(installedBundles, false);
        FrameInformationManager.printInfo();
        if (this.bundleList.size() == bundleCount) {
            this.bundlesState = 1;
            log.warn((Object)"All bundle started, system is ready.");
        } else {
            this.bundlesState = -1;
            log.warn((Object)"Not all bundle started, system is ready with risk.");
        }
        this.installedBundles.addAll(installedBundles);
    }

    private void installBundles(List<Bundle> installedBundles, boolean isReload) {
        LinkedHashSet<String> stopedBundlesName = new LinkedHashSet<String>();
        long time = 0L;
        for (Bundle bundle : installedBundles) {
            try {
                if (log.isDebugEnabled()) {
                    time = System.currentTimeMillis();
                }
                if (StatusInfoUtil.isFrameworkStopping()) {
                    log.warn((Object)"DS be stop and load progress be stopped.");
                    break;
                }
                String symbolicName = bundle.getSymbolicName();
                boolean isChecked = Framework.check(symbolicName);
                Object requireBundle = bundle.getHeaders().get(REQUIRE_BUNDLE);
                String[] requireBundleNames = requireBundle == null ? new String[]{} : requireBundle.toString().split(",");
                boolean requireBundleStoped = false;
                for (String requireBundleName : requireBundleNames) {
                    if (!stopedBundlesName.contains(requireBundleName)) continue;
                    requireBundleStoped = true;
                    break;
                }
                if (requireBundleStoped) {
                    this.stopBundle(bundle, stopedBundlesName);
                    continue;
                }
                if (isReload) {
                    if (!isChecked) {
                        this.stopBundle(bundle, stopedBundlesName);
                        bundle.uninstall();
                        throw new Exception("lincense check failed for reloading bundle: " + bundle.getSymbolicName());
                    }
                    if (bundle.getState() == 32) {
                        continue;
                    }
                } else if (!isChecked) {
                    this.stopBundle(bundle, stopedBundlesName);
                    throw new Exception("lincense check failed for bundle: " + bundle.getSymbolicName());
                }
                bundle.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("start bundle: " + bundle.getSymbolicName() + " use " + (System.currentTimeMillis() - time) + " ms."));
                }
                this.bundleList.add(new BundleHolder(bundle));
                log.warn((Object)("bundle '" + bundle.getSymbolicName() + "' started."));
            }
            catch (Exception e) {
                log.error((Object)("start bundle '" + bundle.getSymbolicName() + "' failed"), (Throwable)e);
                if (this.bundleSet.contains(bundle.getSymbolicName())) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                FrameInformationManager.getInstance().record("Bundle start", String.format("Checking bundle(%s) start ", bundle.getSymbolicName()), false);
                FrameInformationManager.printInfo();
                System.exit(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBundle(Bundle bundle, Set<String> stopedBundlesName) throws BundleException {
        try {
            if (bundle.getState() == 32) {
                bundle.stop();
            }
        }
        finally {
            stopedBundlesName.add(bundle.getSymbolicName());
        }
    }

    private Bundle installBundle(File location) throws Exception {
        URL referenceURL = new URL("reference", null, "file:" + location.getAbsolutePath() + "/");
        InputStream in = referenceURL.openStream();
        String name = "initial@reference:" + location.toURI().toURL().toString();
        Bundle bundle = this.context.installBundle(name, in);
        in.close();
        return bundle;
    }

    protected File getConfigFile() throws Exception {
        String basefile = System.getProperty(PROPERTY_BASEFILE);
        File parent = Framework.getConfigDir();
        String configFilename = System.getProperty(PROPERTY_CONFIG);
        if (basefile == null) {
            if (configFilename == null) {
                configFilename = "default.instance";
            } else if (!configFilename.endsWith(CONFIG_EXT_NAME)) {
                configFilename = configFilename + CONFIG_EXT_NAME;
            }
        } else {
            configFilename = !basefile.endsWith(CONFIG_EXT_NAME) ? basefile + CONFIG_EXT_NAME : basefile;
        }
        File cfg = new File(parent, configFilename);
        if (!cfg.exists() && basefile != null) {
            if (!basefile.endsWith(CONFIG_EXT_NAME)) {
                basefile = basefile + CONFIG_EXT_NAME;
            }
            log.warn((Object)("instance file:" + basefile));
            return new File(parent, basefile);
        }
        return cfg;
    }

    public void shutdownBundles() throws Exception {
        if (this.context == null) {
            return;
        }
        for (int i = this.bundleList.size() - 1; i >= 0; --i) {
            Bundle bundle = this.context.getBundle(this.bundleList.get((int)i).bundleId);
            if (bundle == null) continue;
            long time = 0L;
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis();
            }
            bundle.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)("stop bundle: " + bundle.getSymbolicName() + " use " + (System.currentTimeMillis() - time) + " ms."));
            }
            log.warn((Object)("bundle " + bundle.getSymbolicName() + " stopped."));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bundleSet.clear();
        if (this.autoUpdateTimer != null) {
            this.autoUpdateTimer.cancel();
        }
        this.shutdownBundles();
        if (this.dog != null) {
            this.dog.stop();
            this.dog = null;
        }
        log.warn((Object)"framework stopped!");
    }

    @Override
    public void run() {
        try {
            if (this.context == null) {
                return;
            }
            for (BundleHolder holder : this.bundleList) {
                Bundle bundle;
                if (!holder.checkModified() || (bundle = this.context.getBundle(holder.bundleId)) == null) continue;
                try {
                    bundle.update();
                    ServiceReference packageAdminRef = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
                    if (packageAdminRef == null) continue;
                    PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
                    packageAdmin.refreshPackages(new Bundle[]{bundle});
                }
                catch (BundleException e) {
                    log.error((Object)"update bundle failed");
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"update timer have problem.", (Throwable)e);
        }
    }

    public void reload() throws Exception {
        this.installBundles(this.installedBundles, true);
    }

    class BundleListComparator
    implements Comparator<String> {
        BundleListComparator() {
        }

        @Override
        public int compare(String string1, String string2) {
            if (null != string1 && null != string2) {
                String temp = string1.substring(0, string1.indexOf("_"));
                String temp1 = string2.substring(0, string2.indexOf("_"));
                try {
                    if (Integer.parseInt(temp) > Integer.parseInt(temp1)) {
                        return 1;
                    }
                    if (Integer.parseInt(temp) < Integer.parseInt(temp1)) {
                        return -1;
                    }
                }
                catch (NumberFormatException ne) {
                    log.error((Object)("Number format exception while comparing:- " + string1 + "and " + string2));
                }
            }
            return 0;
        }
    }
}

