/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.util;

import java.util.TimeZone;

public class ZoneInfoStruct {
    private int m_iOffset = 0;
    private String m_strDescription = "";
    private TimeZone zone = null;

    public ZoneInfoStruct(int iOffset, String strDescription) {
        this.m_iOffset = iOffset;
        this.m_strDescription = strDescription;
    }

    public ZoneInfoStruct(TimeZone zone) {
        this.zone = zone;
    }

    public String toString() {
        if (this.zone != null) {
            long offset = this.zone.getRawOffset();
            StringBuffer name = new StringBuffer("");
            name.append("(UTC");
            name.append(ZoneInfoStruct.ms2Hm(offset));
            name.append(")--");
            name.append(this.zone.getDisplayName());
            name.append(" (");
            name.append(this.zone.getID());
            name.append(")");
            return name.toString();
        }
        return this.m_strDescription;
    }

    public String getZoneName() {
        if (this.zone != null) {
            return this.zone.getID();
        }
        return null;
    }

    public int getZoneOffset() {
        if (this.zone != null) {
            return this.zone.getRawOffset() / 1000 / 60;
        }
        return this.m_iOffset;
    }

    public static String ms2Hm(long ms) {
        long h = ms / 3600000L;
        long m = ms % 3600000L / 60000L;
        if (ms < 0L) {
            String HH = Long.toString(-h);
            String mm = Long.toString(-m);
            HH = HH.length() >= 2 ? HH : "0" + HH;
            HH = "-" + HH;
            mm = mm.length() >= 2 ? mm : "0" + mm;
            return new String(HH + ":" + mm);
        }
        String HH = Long.toString(h);
        String mm = Long.toString(m);
        HH = HH.length() >= 2 ? HH : "0" + HH;
        HH = "+" + HH;
        mm = mm.length() >= 2 ? mm : "0" + mm;
        return new String(HH + ":" + mm);
    }

    public boolean equals(Object o) {
        ZoneInfoStruct struct;
        boolean rest = false;
        if (o instanceof ZoneInfoStruct && (struct = (ZoneInfoStruct)o) != null && struct.getZoneOffset() == this.getZoneOffset()) {
            if (struct.getZoneName() != null && struct.getZoneName().equals(this.getZoneName())) {
                rest = true;
            } else if (struct.getZoneName() == null && this.getZoneName() == null) {
                rest = true;
            }
        }
        return rest;
    }
}

