/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.util;

import com.swimap.imap.general.GeneralModule;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class ZoneInfoResBundle {
    private static final IviewLogger logger = IviewLogger.getLogger(ZoneInfoResBundle.class, (String)"TM");
    private Hashtable m_hashTable = new Hashtable();
    private static String GENERAL_RES_FILE = "general/timeZoneInfo";
    private static ResourceBundle resBundle = GeneralModule.getPlugin().getResource().getResourceBundleFromPropertyFile(GENERAL_RES_FILE);

    public void loadFile(String filename) {
        try {
            CommStyleInfo commStyleInfo = GeneralModule.getPlugin().getCommStyleParser().getCommStyleInfo(filename);
            if (commStyleInfo == null) {
                return;
            }
            int count = commStyleInfo.getAreaDescCount();
            for (int i = 0; i < count; ++i) {
                AreaDescContainer areaMain = commStyleInfo.getAreaDescContainer(i);
                DescContainer descContainer = null;
                String paraName = null;
                String paraValue = null;
                for (int j = 0; j < areaMain.getDescCount(); ++j) {
                    descContainer = areaMain.getDescContainer(j);
                    for (int k = 0; k < descContainer.getParasItemCount(); ++k) {
                        PARA para = descContainer.getParasItem(k);
                        paraName = para.getName().trim();
                        paraValue = para.getValue().trim();
                        this.setProperty(paraName, paraValue);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.trace((Object)ex);
        }
    }

    public String getProperty(String skey) {
        return (String)this.m_hashTable.get(skey);
    }

    private Object setProperty(String skey, String svalue) {
        if (skey == null || svalue == null) {
            return null;
        }
        return this.m_hashTable.put(skey, svalue);
    }

    public String getString(String szKey) {
        try {
            if (szKey == null) {
                return "";
            }
            return resBundle.getString(szKey);
        }
        catch (Exception ex) {
            logger.trace((Object)ex);
            return szKey;
        }
    }
}

