/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.util;

import com.swimap.imap.general.util.ZoneInfoStruct;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ZoneInfoComboBox
extends JComboBox {
    private static Vector<ZoneInfoStruct> zoneVector = null;
    private static HashMap<String, ZoneInfoStruct> zoneMap = null;
    private static HashMap<Integer, ZoneInfoStruct> zoneMapAdpter = null;
    private static Graphics2D standardGraphics = new BufferedImage(10, 10, 2).createGraphics();
    private static FontMetrics metrics = standardGraphics.getFontMetrics();

    private ZoneInfoComboBox(Vector items) {
        super(items);
    }

    public void setSelectedZone(String zoneName) {
        if (zoneMap != null) {
            ZoneInfoStruct item = zoneMap.get(zoneName);
            if (item != null) {
                this.setSelectedItem(item);
            } else {
                this.setSelectedIndex(0);
            }
        }
    }

    public void setSelectedZone(int iOffset) {
        ZoneInfoStruct zoneObject;
        if (zoneMapAdpter != null && (zoneObject = zoneMapAdpter.get(new Integer(iOffset))) != null) {
            this.setSelectedItem(zoneObject);
        }
    }

    public ZoneInfoStruct getZoneInfo(int iOffset) {
        if (zoneMapAdpter != null) {
            return zoneMapAdpter.get(new Integer(iOffset));
        }
        return null;
    }

    public ZoneInfoStruct getZoneInfo(String zoneName) {
        if (zoneMap != null) {
            return zoneMap.get(zoneName);
        }
        return null;
    }

    private static synchronized void loadZoneInfo() {
        if (zoneVector == null) {
            String[] ids;
            zoneVector = new Vector();
            zoneMapAdpter = new HashMap();
            zoneMap = new HashMap();
            ZoneInfoStruct zoneStruct = null;
            for (String id : ids = TimeZone.getAvailableIDs()) {
                TimeZone zone = TimeZone.getTimeZone(id);
                zoneStruct = new ZoneInfoStruct(zone);
                zoneVector.add(zoneStruct);
                zoneMap.put(id, zoneStruct);
                zoneMapAdpter.put(zone.getRawOffset() / 1000 / 60, zoneStruct);
            }
        }
    }

    public static ZoneInfoComboBox createZoneInfoComboBox() {
        ZoneInfoComboBox.loadZoneInfo();
        ZoneInfoComboBox zoneInfoComboBox = new ZoneInfoComboBox((Vector)zoneVector){

            public ListCellRenderer getRenderer() {
                return new BasicComboBoxRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Component cp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        ZoneInfoComboBox.setToolTipText(list, value.toString());
                        return cp;
                    }
                };
            }
        };
        ZoneInfoComboBox.setToolTipText(zoneInfoComboBox, zoneVector.get(0).toString());
        zoneInfoComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JComboBox source = (JComboBox)e.getSource();
                    ZoneInfoComboBox.setToolTipText(source, e.getItem().toString());
                }
            }
        });
        return zoneInfoComboBox;
    }

    private static void setToolTipText(JComponent component, String text) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        String tipText = null;
        int width = Toolkit.getDefaultToolkit().getScreenSize().width / 3;
        if (text != null && text.length() > 0) {
            tipText = text;
            if (component.getToolTipText() != null && !component.getToolTipText().equals(ZoneInfoComboBox.formatMultiLine(tipText, width))) {
                toolTipManager.setEnabled(false);
            } else if (component.getToolTipText() == null || component.getToolTipText().trim().length() == 0) {
                toolTipManager.setEnabled(false);
            }
        } else if (text == null || text.trim().length() == 0) {
            toolTipManager.setEnabled(false);
        }
        toolTipManager.setEnabled(true);
        component.setToolTipText(ZoneInfoComboBox.formatMultiLine(tipText, width));
    }

    private static String formatMultiLine(String text, int width) {
        if (text == null || text.equals("")) {
            return text;
        }
        String content = ZoneInfoComboBox.getMultiLine(text, width, metrics);
        return "<html>" + content + "</html>";
    }

    private static String getMultiLine(String text, int width, FontMetrics metrics) {
        int iTextLength = metrics.stringWidth(text);
        if (iTextLength <= width) {
            return text;
        }
        int iMultiple = iTextLength / width;
        int endIndex = text.length() / iMultiple / 2;
        String s = text.substring(0, endIndex);
        while (metrics.stringWidth(s) > width) {
            s = s.substring(0, s.length() / 2);
        }
        int iSubLength = s.length();
        int i = 1;
        while (metrics.stringWidth(s) < width) {
            s = text.substring(0, iSubLength + i);
            ++i;
        }
        String next = text.substring(s.length());
        if (next.equals("")) {
            return s;
        }
        return s + "<br>" + ZoneInfoComboBox.getMultiLine(next, width, metrics);
    }
}

