/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.util;

import com.swimap.iview.util.log.IviewLogger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TextDocument
extends PlainDocument {
    private static final IviewLogger logger = IviewLogger.getLogger(TextDocument.class, (String)"TM");
    public static final String initString = "";
    private JTextComponent textComponent;
    public int MAX_LENGTH = 10;

    public TextDocument(JTextComponent tc, int MaxLength) {
        this.textComponent = tc;
        this.MAX_LENGTH = MaxLength;
        try {
            this.insertString(0, initString, null);
        }
        catch (Exception ex) {
            logger.error((Object)initString, (Throwable)ex);
        }
    }

    @Override
    public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        if (s == null) {
            super.insertString(offset, s, attributeSet);
            return;
        }
        if (s.equalsIgnoreCase(initString)) {
            super.insertString(offset, s, attributeSet);
        } else {
            char[] tmpChar = s.toCharArray();
            if (offset == 0 && tmpChar[0] == ' ') {
                return;
            }
            for (int i = 0; i < s.length(); ++i) {
                if (tmpChar[i] <= 'z' && tmpChar[i] >= 'a' || tmpChar[i] <= 'Z' && tmpChar[i] >= 'A' || tmpChar[i] <= '9' && tmpChar[i] >= '0' || tmpChar[i] == '.' || tmpChar[i] == ' ' || tmpChar[i] > '\u00ad' || tmpChar[i] == '_' || tmpChar[i] == '-') continue;
                return;
            }
            int lenth = this.textComponent.getText().getBytes().length;
            if (lenth + s.getBytes().length > this.MAX_LENGTH) {
                return;
            }
            super.insertString(offset, s, attributeSet);
        }
    }
}

