/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.util;

import com.swimap.imap.common.commoninterface.general.AudioPlayerInterface;
import com.swimap.imap.common.commoninterface.general.StopListener;
import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.util.AudioPlayer;
import java.applet.AudioClip;

public class AuditionPlayer
implements AudioPlayerInterface,
StopListener {
    private static AuditionPlayer instance = new AuditionPlayer();
    private AudioPlayer player = new AudioPlayer("AuditionPlayer Thread");
    private StopListener stopListener = null;

    public AuditionPlayer() {
        this.player.registerStopListener(this);
    }

    public static AuditionPlayer getInstance() {
        if (null == instance) {
            instance = new AuditionPlayer();
            GeneralLogger.debug((String)"New a instance of AuditionPlayer succeed.");
        }
        return instance;
    }

    public void playSound(AudioClip clip, int iSoundTime, StopListener listener) {
        this.stopSound();
        if (listener != this.stopListener && this.stopListener != null) {
            this.stopListener.doStop();
        }
        if (null == listener) {
            GeneralLogger.debug((String)"Alarm: playSound parameter-[listener] is null.");
        }
        this.stopListener = listener;
        if (null == clip) {
            GeneralLogger.error((String)"Error: playSound parameter-[clip] is null.");
            return;
        }
        if (iSoundTime < -1) {
            GeneralLogger.error((String)"Error: playSound parameter-[iSoundTime] is less than -1.");
            return;
        }
        if (iSoundTime == -1) {
            iSoundTime = Integer.MAX_VALUE;
        } else {
            if (iSoundTime == 0) {
                this.doStop();
                return;
            }
            if (iSoundTime > 0 && iSoundTime * 1000 < 0) {
                iSoundTime = Integer.MAX_VALUE;
                GeneralLogger.debug((String)"Alarm: playSound parameter-[iSoundTime] is to big than MAX_VALUE[0x7fffffff].");
            } else {
                iSoundTime *= 1000;
            }
        }
        this.player.startPlaying(clip, iSoundTime);
    }

    public void stopSound() {
        this.player.stopPlaying();
    }

    public void doStop() {
        if (this.stopListener != null) {
            this.stopListener.doStop();
        }
    }
}

