/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.util;

import com.swimap.imap.common.commoninterface.general.StopListener;
import com.swimap.imap.general.GeneralLogger;
import java.applet.AudioClip;
import java.util.ArrayList;
import java.util.List;

public class AudioPlayer {
    private AudioClip audioClip = null;
    private long playTime;
    private boolean reloop = true;
    private List stopListeners = new ArrayList();
    private boolean isExit = false;
    private Object lock = new Object();
    private Thread thread = null;

    public AudioPlayer(String playerName) {
        this.initPlayerThread(playerName);
    }

    private void initPlayerThread(final String playerName) {
        this.thread = new Thread(playerName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long tempPlayTime = 0L;
                while (!AudioPlayer.this.isExit) {
                    try {
                        boolean isOverTime = false;
                        Object object = AudioPlayer.this.lock;
                        synchronized (object) {
                            if (AudioPlayer.this.audioClip == null) {
                                AudioPlayer.this.lock.wait();
                            }
                            if (AudioPlayer.this.audioClip == null) {
                                continue;
                            }
                            if (AudioPlayer.this.reloop) {
                                AudioPlayer.this.audioClip.loop();
                            }
                            tempPlayTime = AudioPlayer.this.playTime;
                            long lStartTime = System.currentTimeMillis();
                            AudioPlayer.this.lock.wait(tempPlayTime);
                            long lEndTime = System.currentTimeMillis();
                            if (lEndTime - lStartTime >= tempPlayTime - 200L) {
                                if (AudioPlayer.this.audioClip != null) {
                                    AudioPlayer.this.audioClip.stop();
                                    AudioPlayer.this.audioClip = null;
                                }
                                isOverTime = true;
                                AudioPlayer.this.playTime = 0L;
                                AudioPlayer.this.reloop = true;
                            }
                        }
                        if (!isOverTime) continue;
                        AudioPlayer.this.fireStopAction();
                    }
                    catch (Exception e) {
                        GeneralLogger.error((String)e.getMessage());
                    }
                }
                GeneralLogger.debug((String)(playerName + "Thread exit"));
            }
        };
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlaying() {
        Object object = this.lock;
        synchronized (object) {
            if (this.audioClip != null) {
                this.audioClip.stop();
            }
            this.audioClip = null;
            this.reloop = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlaying(AudioClip clip, long playTime) {
        Object object = this.lock;
        synchronized (object) {
            this.playTime = playTime;
            if (this.audioClip != null) {
                if (!this.audioClip.equals(clip)) {
                    this.audioClip.stop();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        GeneralLogger.error((String)e.getMessage());
                    }
                    this.audioClip = clip;
                    this.reloop = true;
                } else {
                    this.reloop = false;
                }
            } else {
                this.audioClip = clip;
                this.reloop = true;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.stopPlaying();
            this.stopListeners.clear();
            this.isExit = true;
            this.lock.notifyAll();
            GeneralLogger.debug((String)"close AuditionPlayer");
        }
    }

    private void fireStopAction() {
        for (int i = 0; i < this.stopListeners.size(); ++i) {
            Object obj = this.stopListeners.get(i);
            StopListener stopListener = (StopListener)obj;
            stopListener.doStop();
        }
    }

    public void registerStopListener(StopListener listener) {
        this.stopListeners.add(listener);
    }

    public boolean unregisterStopListener(StopListener listener) {
        return this.stopListeners.remove(listener);
    }
}

