/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.sound;

import com.swimap.imap.common.commoninterface.general.StopListener;
import com.swimap.imap.common.commoninterface.general.sound.IPlayInfo;
import com.swimap.imap.common.commoninterface.general.sound.IPlayerManager;
import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.util.AudioPlayer;
import java.util.HashMap;
import java.util.Map;

public class PlayerManager
implements IPlayerManager,
StopListener {
    private final Map type2Priority = new HashMap();
    private IPlayInfo currentPlayInfo = null;
    private boolean isPlayable = true;
    private AudioPlayer player = new AudioPlayer("General sound player thread");

    public PlayerManager() {
        this.player.registerStopListener(this);
        GeneralLogger.debug((String)"new an instance of PlayerManager.");
    }

    public synchronized void registerType2Priority(Map type2Priority) {
        if (type2Priority == null || type2Priority.isEmpty()) {
            GeneralLogger.debug((String)"the registered map is null or empty.");
            return;
        }
        this.type2Priority.putAll(type2Priority);
    }

    public synchronized void play(IPlayInfo playInfo) {
        if (!this.isPlayable) {
            return;
        }
        if (!this.checkInfoPlayable(playInfo)) {
            return;
        }
        this.playImpl_0(playInfo);
    }

    private boolean checkPriority(IPlayInfo current, IPlayInfo wantTo) {
        int newPriority;
        int currentPriority = this.getPriority(current.getPlayType());
        return currentPriority <= (newPriority = this.getPriority(wantTo.getPlayType()));
    }

    private void playImpl_0(IPlayInfo playInfo) {
        if (this.currentPlayInfo == null) {
            this.playImpl_1(playInfo);
            return;
        }
        if (this.checkPriority(this.currentPlayInfo, playInfo)) {
            this.playImpl_1(playInfo);
        } else {
            GeneralLogger.debug((String)"checkPriority return false.");
        }
    }

    private void playImpl_1(IPlayInfo playInfo) {
        this.currentPlayInfo = playInfo;
        this.player.startPlaying(playInfo.getAudioClip(), playInfo.getPlayTime());
    }

    private boolean checkInfoPlayable(IPlayInfo playInfo) {
        return playInfo != null && playInfo.isPlayable() && playInfo.getPlayTime() != 0L && playInfo.getAudioClip() != null;
    }

    public synchronized void play(IPlayInfo[] playInfos) {
        if (!this.isPlayable) {
            return;
        }
        if (playInfos == null || playInfos.length == 0) {
            return;
        }
        IPlayInfo toPlay = this.filterPlayInfo(playInfos);
        if (toPlay == null) {
            GeneralLogger.debug((String)"toPlay is null.");
            return;
        }
        this.playImpl_0(toPlay);
    }

    private IPlayInfo filterPlayInfo(IPlayInfo[] playInfos) {
        int filteredIndex = -1;
        int maxPriority = -1;
        for (int i = 0; i < playInfos.length; ++i) {
            if (playInfos[i] == null || !playInfos[i].isPlayable()) continue;
            if (filteredIndex == -1) {
                filteredIndex = i;
                maxPriority = this.getPriority(playInfos[i].getPlayType());
                continue;
            }
            int newPriority = this.getPriority(playInfos[i].getPlayType());
            if (newPriority < maxPriority) continue;
            filteredIndex = i;
            maxPriority = newPriority;
        }
        if (filteredIndex == -1) {
            return null;
        }
        if (playInfos[filteredIndex].getPlayTime() == 0L || playInfos[filteredIndex].getAudioClip() == null) {
            return null;
        }
        return playInfos[filteredIndex];
    }

    public synchronized void stop(IPlayInfo playInfo) {
        if (this.currentPlayInfo == playInfo) {
            this.stop();
        } else {
            GeneralLogger.debug((String)"The sound to stop is not the one playing.");
        }
    }

    public synchronized void stop() {
        if (this.currentPlayInfo == null) {
            return;
        }
        this.player.stopPlaying();
        this.currentPlayInfo = null;
    }

    public synchronized IPlayInfo getCurrentPlayInfo() {
        return this.currentPlayInfo;
    }

    public synchronized void setPlayable(boolean isPlayable) {
        this.isPlayable = isPlayable;
        if (!isPlayable) {
            this.stop();
        }
        GeneralLogger.debug((String)("set playable: " + isPlayable));
    }

    public synchronized boolean isPlayable() {
        return this.isPlayable;
    }

    public int getPriority(String type) {
        Object priority = this.type2Priority.get(type);
        if (priority == null) {
            GeneralLogger.debug((String)("the type is not conained in the map: " + type));
            return -1;
        }
        return (Integer)priority;
    }

    public synchronized void doStop() {
        this.currentPlayInfo = null;
    }

    public synchronized void exit() {
        this.currentPlayInfo = null;
        this.player.close();
    }
}

