/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.setting;

import com.swimap.external.common.adapter.message.util.CommonLogger;
import com.swimap.imap.common.commoninterface.general.ISoundConfig;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.io.File;

public class EmfSoundConfig
implements ISoundConfig {
    private String key = null;
    private String soundDesc = null;
    private String soundFileName = null;
    private int time = -1;
    private boolean isSoundable = false;

    public EmfSoundConfig() {
    }

    public EmfSoundConfig(String key, String soundDesc, String soundFileName, String time, String isSoundable) {
        if (key != null) {
            this.key = key;
        } else {
            CommonLogger.debug((String)"The sound key is null");
        }
        try {
            this.isSoundable = Integer.parseInt(isSoundable) == 1;
        }
        catch (Exception e1) {
            this.isSoundable = true;
        }
        try {
            this.time = Integer.parseInt(time);
        }
        catch (Exception e2) {
            this.time = 30;
        }
        this.soundFileName = soundFileName == null ? " " : soundFileName;
        this.soundDesc = soundDesc;
    }

    public void setSoundFileName(String soundFileName) {
        this.soundFileName = soundFileName;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setIsSoundable(boolean isSoundable) {
        this.isSoundable = isSoundable;
    }

    public void setSoundDesc(String soundDesc) {
        this.soundDesc = soundDesc;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getSoundFileName() {
        String stCompareResDir;
        if (this.soundFileName.trim().equals("")) {
            return this.soundFileName;
        }
        String stResDir = ResourceMng.getInstance().getResourceDir();
        String stCompareFileName = this.soundFileName.replace('/', '\\');
        if (stCompareFileName.startsWith(stCompareResDir = stResDir.replace('/', '\\'))) {
            File file = ResourceMng.getInstance().getSoundFileDirect(this.soundFileName);
            this.soundFileName = file.getAbsolutePath();
        }
        return this.soundFileName;
    }

    public int getTime() {
        return this.time;
    }

    public boolean isPlaySound() {
        return this.isSoundable;
    }

    public String getSoundDesc() {
        return this.soundDesc;
    }

    public Object clone() {
        EmfSoundConfig o = new EmfSoundConfig();
        o.key = this.key;
        o.soundDesc = this.soundDesc;
        o.soundFileName = this.soundFileName;
        o.time = this.time;
        o.isSoundable = this.isSoundable;
        return o;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        EmfSoundConfig sound = (EmfSoundConfig)obj;
        return this.key.equals(sound.getKey()) && this.isSoundable == sound.isPlaySound() && this.soundFileName.equals(sound.getSoundFileName()) && this.soundDesc.equals(sound.getSoundDesc()) && this.time == sound.getTime();
    }
}

