/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.progress;

import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.progress.ProgressEvent;
import com.swimap.imap.general.progress.ProgressListener;
import com.swimap.imap.general.progress.ProgressManager;
import com.swimap.iview.communicate.CommService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public abstract class SimpleProgressTask
implements ProgressListener {
    private static final int NO_TIMEOUT = -1;
    private int missionID = -1;
    private CommService comm = null;
    private Timer timeoutTimer = null;
    private ActionListener timeoutAction;
    private int timeout = -1;
    private int state = 0;

    public SimpleProgressTask(int moduleID, int timeout) {
        this.missionID = this.getManager().generateID(moduleID);
        this.timeout = timeout;
        if (timeout != -1) {
            this.initTimeoutAction();
        }
    }

    private void initTimeoutAction() {
        if (this.timeoutAction == null) {
            this.timeoutAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SimpleProgressTask.this.state == 0) {
                        return;
                    }
                    SimpleProgressTask.this.state = 2;
                    GeneralLogger.trace("The progress task timeoutTimer has timed out, the missionID is " + SimpleProgressTask.this.missionID);
                    SimpleProgressTask.this.handleTimeOut();
                }
            };
        }
    }

    private void startTimeOut() {
        if (this.timeoutTimer == null && this.timeoutAction != null) {
            GeneralLogger.trace("Start a new progress task timeoutTimer, the missionID is " + this.missionID);
            this.timeoutTimer = new Timer(this.timeout, this.timeoutAction);
            this.timeoutTimer.start();
        }
    }

    private void resetTimeOut() {
        if (this.timeoutTimer != null) {
            GeneralLogger.trace("Reset the progress task timeoutTimer, the missionID is " + this.missionID);
            this.timeoutTimer.restart();
        }
    }

    private void stopTimeOut() {
        if (this.timeoutTimer != null) {
            GeneralLogger.trace("Stop the progress task timeoutTimer, the missionID is " + this.missionID);
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
        }
    }

    public void startTask(CommService comm) {
        if (comm == null) {
            return;
        }
        this.comm = comm;
        this.state = 1;
        this.getManager().registerCommService(comm);
        this.getManager().addProgressListener(this.missionID, this);
        this.startTimeOut();
    }

    public synchronized void stopTask() {
        if (this.state == 0) {
            return;
        }
        this.state = 0;
        this.getManager().unregisterCommService(this.comm);
        this.getManager().removeProgressListener(this.missionID);
        this.stopTimeOut();
    }

    @Override
    public void progressChange(ProgressEvent event) {
        if (this.state != 1) {
            return;
        }
        GeneralLogger.trace("MissionID: " + this.missionID + ". Current progress is " + event.getValue());
        this.resetTimeOut();
        this.updateProgressUI(event);
    }

    public int getMissionID() {
        return this.missionID;
    }

    public int getProgressState() {
        return this.state;
    }

    public void setProgressState(int state) {
        this.state = state;
    }

    public void close() {
        this.stopTask();
        this.timeoutAction = null;
    }

    public ProgressManager getManager() {
        return ProgressManager.getInstance();
    }

    protected abstract void updateProgressUI(ProgressEvent var1);

    protected abstract void handleTimeOut();

    public static class State {
        public static final int NOTASK = 0;
        public static final int RUNNING = 1;
        public static final int TIMEOUT = 2;
    }
}

