/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.progress;

import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.progress.AbstractProgressMsgDisplayer;
import com.swimap.imap.general.progress.DefaultProgressMsgDisplayer;
import com.swimap.imap.general.progress.DefaultProgressReporter;
import com.swimap.imap.general.progress.ProgressCancelListener;
import com.swimap.imap.general.progress.ProgressEvent;
import com.swimap.imap.general.progress.ProgressListener;
import com.swimap.imap.general.progress.ProgressMsgReporter;
import com.swimap.iview.communicate.AppAidedMsgReceiver;
import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;

public abstract class ProgressTask
implements ProgressCancelListener,
ProgressListener {
    private static int index = -1;
    private static final int DEFAULT_TIMEOUT = 9000;
    private int timeout = -1;
    private int progressID = -1;
    private AbstractProgressMsgDisplayer displayer;
    private ProgressMsgReporter reporter;
    private String name;
    private boolean isTimeout = false;
    protected AppAidedMsgReceiver receiver = null;
    private boolean isTaskCancel = false;

    protected abstract void processMessage(MSGPacketExt var1);

    protected abstract MSGPacketExt getSendPacket(int var1, int var2);

    protected abstract void handleTimeout();

    protected abstract CommHandle getCommHandle();

    protected abstract boolean cancelTask(int var1);

    public void startProgressTask() throws Exception {
        this.receiver = new AppAidedMsgReceiver(){

            protected boolean processMessage(MSGPacketExt msg) {
                try {
                    super.close();
                }
                catch (Exception e) {
                    GeneralLogger.trace(e);
                }
                if (!ProgressTask.this.isTimeout && !ProgressTask.this.isTaskCancel) {
                    ProgressTask.this.processMessage(msg);
                }
                return true;
            }

            protected int handleTimeout() {
                if (!ProgressTask.this.isTimeout && !ProgressTask.this.isTaskCancel) {
                    ProgressTask.this.setTimeout();
                    ProgressTask.this.handleTimeout();
                }
                return 0;
            }
        };
        MSGPacketExt packetExt = this.getSendPacket(this.progressID, this.timeout);
        this.getCommHandle().sendAsyncMessage(packetExt, (MSGListener)this.receiver, this.timeout);
        this.displayer.show();
    }

    private void setTimeout() {
        this.isTimeout = true;
    }

    public ProgressTask(String name) {
        this(name, 9000, new DefaultProgressMsgDisplayer());
    }

    public ProgressTask(String name, int timeout) {
        this(name, timeout, new DefaultProgressMsgDisplayer());
    }

    public ProgressTask(String name, int timeout, AbstractProgressMsgDisplayer displayer) {
        this(name, timeout, displayer, DefaultProgressReporter.getInstance());
    }

    public ProgressTask(String name, int timeout, AbstractProgressMsgDisplayer displayer, ProgressMsgReporter reporter) {
        this.name = name;
        this.timeout = timeout;
        this.progressID = this.generateID();
        this.setProgressReporter(reporter);
        this.setMsgDisplayer(displayer);
        displayer.setTitle(this.name);
    }

    public void end() {
        if (null != this.receiver && (this.isTaskCancel || this.isTimeout)) {
            this.receiver.close();
        }
        this.displayer.unregesterCancelListener(this);
        this.displayer.close();
        this.reporter.unRegister(this.getCommHandle());
        this.reporter.removeProgressListener(this.progressID, this);
    }

    private synchronized int generateID() {
        return index++;
    }

    private void setProgressReporter(ProgressMsgReporter reporter) {
        if (this.reporter != null) {
            this.reporter.removeProgressListener(this.progressID, this);
        }
        this.reporter = reporter;
        this.reporter.register(this.getCommHandle());
        this.reporter.addProgressListener(this.progressID, this);
    }

    public void setMsgDisplayer(AbstractProgressMsgDisplayer displayer) {
        if (this.displayer != null) {
            this.displayer.unregesterCancelListener(this);
        }
        this.displayer = displayer;
        this.displayer.registerCancelListener(this);
    }

    public int getProgressID() {
        return this.progressID;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void progressChange(ProgressEvent event) {
        this.displayer.updateProgress(event.getValue(), event.getDescription(), event.getDetailInfos());
        if (event.getValue() >= 100) {
            this.end();
        }
    }

    @Override
    public void cancel() {
        if (this.cancelTask(this.progressID)) {
            this.isTaskCancel = true;
            this.end();
        }
    }
}

