/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.progress;

import com.swimap.imap.common.asn1.asnprogress.AsnProgressDetail;
import com.swimap.imap.common.asn1.asnprogress.AsnProgressDetailList;
import com.swimap.imap.common.asn1.asnprogress.AsnProgressReport;
import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.GeneralUtils;
import com.swimap.imap.general.progress.ProgressDetailInfo;
import com.swimap.imap.general.progress.ProgressEvent;
import com.swimap.imap.general.progress.ProgressListener;
import com.swimap.iview.communicate.CommService;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGReceiver;
import java.math.BigInteger;
import java.util.Enumeration;
import org.apache.batik.dom.util.HashTable;

public class ProgressManager {
    private static final int PROGRESS_CMD_CODE = 3104;
    private HashTable progressListeners = new HashTable();
    private HashTable commMissions = new HashTable();
    private ProgressMSGListener msgListener = new ProgressMSGListener();
    private static ProgressManager _instance = null;

    private ProgressManager() {
    }

    public static synchronized ProgressManager getInstance() {
        if (_instance == null) {
            _instance = new ProgressManager();
        }
        return _instance;
    }

    public synchronized int generateID(int moduleID) {
        long tmpID = System.currentTimeMillis();
        int missionID = BigInteger.valueOf(tmpID % 10000000L + (long)(moduleID * 10000000)).intValue();
        return missionID;
    }

    public void registerCommService(CommService comm) {
        int count = 0;
        if (this.commMissions.get((Object)comm) != null) {
            count = ((BigInteger)this.commMissions.get((Object)comm)).intValue();
        } else {
            comm.addMessageListener(3104, (MSGListener)this.msgListener);
        }
        this.commMissions.put((Object)comm, (Object)BigInteger.valueOf(++count));
    }

    public void unregisterCommService(CommService comm) {
        if (this.commMissions.get((Object)comm) == null) {
            return;
        }
        int count = ((BigInteger)this.commMissions.get((Object)comm)).intValue();
        if (count > 1) {
            this.commMissions.put((Object)comm, (Object)BigInteger.valueOf(--count));
        } else {
            comm.removeMessageListener(3104, (MSGListener)this.msgListener);
            this.commMissions.remove((Object)comm);
        }
    }

    public void addProgressListener(int missionID, ProgressListener listener) {
        this.progressListeners.put((Object)BigInteger.valueOf(missionID), (Object)listener);
    }

    public void removeProgressListener(int missionID) {
        this.progressListeners.remove((Object)BigInteger.valueOf(missionID));
    }

    public void stop() {
        this.progressListeners.clear();
        this.commMissions.clear();
        if (this.msgListener != null) {
            this.msgListener.close();
            this.msgListener = null;
        }
        _instance = null;
    }

    class ProgressMSGListener
    extends MSGReceiver {
        ProgressMSGListener() {
        }

        public void timeout(int cmdCode, Character cmdHandle) {
            GeneralLogger.trace("Receive a timeout progress msg from the server, cmdHandle is: " + cmdHandle);
        }

        protected void processMessage(MSGPacketExt msgpacketext) {
            int cmdCode = msgpacketext.getCmdCode();
            GeneralLogger.trace("Receive a progress msg from the server, cmdCode is " + cmdCode);
            if (cmdCode == 3104) {
                AsnProgressReport asnProgressReport = new AsnProgressReport();
                if (!GeneralUtils.receiveNoticeDecode(msgpacketext, asnProgressReport)) {
                    GeneralLogger.trace("Decode error.");
                    return;
                }
                try {
                    ProgressListener listener = (ProgressListener)ProgressManager.this.progressListeners.get((Object)asnProgressReport.missionID);
                    if (listener != null) {
                        int progressID = asnProgressReport.missionID.intValue();
                        int value = asnProgressReport.progress.intValue();
                        String description = null;
                        if (asnProgressReport.processInfo != null) {
                            description = new String(asnProgressReport.processInfo);
                        }
                        AsnProgressDetailList asnProgressDetailList = asnProgressReport.detailList;
                        ProgressDetailInfo[] detailInfos = null;
                        if (asnProgressDetailList != null) {
                            Enumeration enumeration = asnProgressDetailList.elements();
                            int size = asnProgressDetailList.size();
                            detailInfos = new ProgressDetailInfo[size];
                            int i = 0;
                            while (enumeration.hasMoreElements()) {
                                AsnProgressDetail element = (AsnProgressDetail)enumeration.nextElement();
                                String strKey = new String(element.detailKey);
                                String strValue = new String(element.detailValue);
                                String strMemo = new String(element.detailMemo);
                                detailInfos[i] = new ProgressDetailInfo(strKey, strValue, strMemo);
                                ++i;
                            }
                        }
                        ProgressEvent event = new ProgressEvent(progressID, value, description, detailInfos);
                        listener.progressChange(event);
                    }
                }
                catch (Exception e) {
                    GeneralLogger.trace(e);
                }
            }
        }
    }
}

