/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.progress;

import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.imap.general.progress.AbstractProgressMsgDisplayer;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.OptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolTip;

public class ProgressDlg
extends JDialog {
    private JPanel parentPanel = null;
    private JPanel progressBarPanel = null;
    private JPanel detailPanel = null;
    private JButton detailBtn = null;
    private JButton cancelBtn = null;
    private JProgressBar progressBar = null;
    private JLabel progressLabel = null;
    private ExtendedTable detailTable = null;
    private JScrollPane scrollPane = null;
    private String[] columnNames = new String[]{GeneralResourceManager.getInstance().getString("Progress_Table_Name"), GeneralResourceManager.getInstance().getString("Progress_Table_Result"), GeneralResourceManager.getInstance().getString("Progress_Table_Memo")};
    private ActionListener detailListener = null;
    private ActionListener cancelListener = null;
    private WindowListener windowListener = null;
    private AbstractProgressMsgDisplayer progressMsgDisplayer = null;
    private boolean showDetail = false;
    private JSeparator separatorHorizontal = new JSeparator(0);
    private int tablePanelHeight;
    KeyEventPostProcessor m_oKeyProcessor = new KeyEventPostProcessor(){

        @Override
        public boolean postProcessKeyEvent(KeyEvent e) {
            if (!ProgressDlg.this.isActive()) {
                return false;
            }
            if (e.getKeyCode() == 27 && e.getID() == 401) {
                ProgressDlg.this.doCancel();
                return true;
            }
            return false;
        }
    };

    public ProgressDlg() {
        super(FrameworkUtilities.getMainFrame(), GeneralResourceManager.getInstance().getString("Task_ProgressBar"), true);
        try {
            this.layoutUI();
            this.initListener();
            this.addListener();
            this.setSize(578, 340);
            this.setResizable(false);
        }
        catch (Exception e) {
            DebugTracer.trace((Exception)e);
        }
    }

    public void setProgressMsgDisplayer(AbstractProgressMsgDisplayer progressMsgDisplayer) {
        this.progressMsgDisplayer = progressMsgDisplayer;
    }

    private JPanel buildProgressBar() {
        JPanel m_progressBarPanel = new JPanel();
        m_progressBarPanel.setLayout(new GridBagLayout());
        this.progressLabel = new JLabel();
        this.progressLabel.setText(GeneralResourceManager.getInstance().getString("Task_Begin"));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressLabel.setPreferredSize(new Dimension(220, 20));
        this.progressBar.setPreferredSize(new Dimension(220, 25));
        this.detailBtn = new JButton();
        this.detailBtn.setText(GeneralResourceManager.getInstance().getString("DetailBtnText") + ">>");
        this.detailBtn.setPreferredSize(new Dimension(120, 21));
        this.detailBtn.setMnemonic('D');
        this.cancelBtn = new JButton();
        this.cancelBtn.setText(GeneralResourceManager.getInstance().getString("Button_Cancel"));
        this.cancelBtn.setPreferredSize(new Dimension(120, 21));
        Component component1 = Box.createVerticalStrut(20);
        m_progressBarPanel.add((Component)this.cancelBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 20), 0, 0));
        m_progressBarPanel.add((Component)this.detailBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 145), 0, 0));
        m_progressBarPanel.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 13, 20), 0, 0));
        m_progressBarPanel.add((Component)this.progressLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 20, 13, 20), 0, 0));
        m_progressBarPanel.add(component1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 13, 0), 0, 0));
        return m_progressBarPanel;
    }

    private JPanel buildDetailPanel() {
        JPanel m_detailPanel = new JPanel();
        m_detailPanel.setLayout(new GridBagLayout());
        this.separatorHorizontal.setPreferredSize(new Dimension(220, 5));
        this.detailTable = new ExtendedTable(new SortableTableModel((Object[])this.columnNames, 0)){

            public String getToolTipText(MouseEvent evt) {
                Object oTmp;
                Point point = evt.getPoint();
                int iRow = this.rowAtPoint(point);
                int iColumn = this.columnAtPoint(point);
                if (iRow > -1 && iColumn > -1 && (oTmp = this.getValueAt(iRow, iColumn)) != null && oTmp.toString().trim().length() > 0) {
                    return oTmp.toString();
                }
                return null;
            }

            public JToolTip createToolTip() {
                MultiRowToolTip oMultiRowTip = new MultiRowToolTip();
                oMultiRowTip.setComponent((JComponent)((Object)this));
                return oMultiRowTip;
            }
        };
        this.detailTable.setSortableClickCount(1);
        this.scrollPane = new JScrollPane((Component)this.detailTable);
        m_detailPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 13, 20), 0, 0));
        m_detailPanel.add((Component)this.separatorHorizontal, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 13, 20), 0, 0));
        return m_detailPanel;
    }

    private void layoutUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.parentPanel = new JPanel();
        this.parentPanel.setLayout(new GridBagLayout());
        this.progressBarPanel = this.buildProgressBar();
        this.detailPanel = this.buildDetailPanel();
        this.getContentPane().add((Component)this.progressBarPanel, "North");
        this.getContentPane().add((Component)this.detailPanel, "Center");
    }

    private void initListener() {
        this.detailListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDlg.this.showDetialInfo();
            }
        };
        this.cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDlg.this.doCancel();
            }
        };
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressDlg.this.doCancel();
            }
        };
    }

    private void addListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.m_oKeyProcessor);
        this.detailBtn.addActionListener(this.detailListener);
        this.cancelBtn.addActionListener(this.cancelListener);
        this.addWindowListener(this.windowListener);
    }

    private void removeListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.m_oKeyProcessor);
        if (null != this.detailListener) {
            this.detailBtn.removeActionListener(this.detailListener);
            this.detailListener = null;
        }
        if (null != this.cancelListener) {
            this.cancelBtn.removeActionListener(this.cancelListener);
            this.cancelListener = null;
        }
        if (null != this.windowListener) {
            this.removeWindowListener(this.windowListener);
            this.windowListener = null;
        }
    }

    private void showDetialInfo() {
        if (this.showDetail) {
            this.showDetail = false;
            this.detailBtn.setText(GeneralResourceManager.getInstance().getString("DetailBtnText") + ">>");
            int height = this.getHeight() + this.tablePanelHeight;
            this.setSize(new Dimension(this.getWidth(), height));
            this.getContentPane().add((Component)this.detailPanel, "Center");
        } else {
            this.showDetail = true;
            this.detailBtn.setText(GeneralResourceManager.getInstance().getString("DetailBtnText") + "<<");
            this.tablePanelHeight = this.detailPanel.getHeight();
            this.getContentPane().remove(this.detailPanel);
            int height = this.getHeight() - this.tablePanelHeight;
            this.setSize(new Dimension(this.getWidth(), height));
        }
        this.validate();
    }

    private void doCancel() {
        if (null == this.progressMsgDisplayer) {
            this.dispose();
        } else {
            int iConfrimResult = OptionPane.showConfirmDialog((Component)this, (Object)GeneralResourceManager.getInstance().getString("TaskCancel"), (String)GeneralResourceManager.getInstance().getString("Confirm"), (int)0);
            if (0 == iConfrimResult) {
                if (null != this.progressMsgDisplayer) {
                    this.progressMsgDisplayer.cancelProgressTask();
                }
                this.dispose();
            }
        }
    }

    @Override
    public void dispose() {
        this.removeListener();
        super.dispose();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JLabel getProgressLabel() {
        return this.progressLabel;
    }

    public SortableTableModel getTableModel() {
        return this.detailTable.getSortableTableModel();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public ExtendedTable getDetailTable() {
        return this.detailTable;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }
}

