/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.progress;

import com.swimap.imap.common.asn1.asnprogress.AsnProgressDetail;
import com.swimap.imap.common.asn1.asnprogress.AsnProgressDetailList;
import com.swimap.imap.common.asn1.asnprogress.AsnProgressReport;
import com.swimap.imap.general.GeneralModule;
import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.imap.general.progress.ProgressDetailInfo;
import com.swimap.imap.general.progress.ProgressEvent;
import com.swimap.imap.general.progress.ProgressListener;
import com.swimap.imap.general.progress.ProgressMsgReporter;
import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGReceiver;
import com.swimap.iview.util.DebugTracer;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruDecoder;
import net.commustru.fstru.FStruct;

public class DefaultProgressReporter
implements ProgressMsgReporter {
    private ProgressMSGListener msgListener = new ProgressMSGListener();
    private static DefaultProgressReporter instance = null;
    private Hashtable progressListenerMap = new Hashtable();
    private Hashtable valueMap = new Hashtable();
    private static int listenerCmdCode = 3104;

    private DefaultProgressReporter() {
    }

    public static synchronized DefaultProgressReporter getInstance() {
        if (instance == null) {
            instance = new DefaultProgressReporter();
        }
        return instance;
    }

    @Override
    public void register(CommHandle handler) {
        GeneralModule.getInstance().m_oCommMgr.getCommService().addMessageListener(listenerCmdCode, (MSGListener)this.msgListener);
    }

    @Override
    public void addProgressListener(int progressID, ProgressListener listener) {
        if (null == this.progressListenerMap) {
            this.progressListenerMap = new Hashtable();
        }
        this.progressListenerMap.put(BigInteger.valueOf(progressID), listener);
        if (null == this.valueMap) {
            this.valueMap = new Hashtable();
        }
        this.valueMap.put(BigInteger.valueOf(progressID), BigInteger.valueOf(0L));
    }

    @Override
    public void removeProgressListener(int progressID, ProgressListener listener) {
        if (null != this.progressListenerMap) {
            this.progressListenerMap.remove(BigInteger.valueOf(progressID));
        }
        if (null != this.valueMap) {
            this.valueMap.remove(BigInteger.valueOf(progressID));
        }
    }

    private static synchronized boolean receiveNoticeDecode(MSGPacketExt data, FStruct noticeObject) {
        if (data == null) {
            return false;
        }
        byte[] bytes = data.getData();
        if (bytes == null) {
            return false;
        }
        FStruDecoder dec = new FStruDecoder(bytes);
        try {
            noticeObject.deserialize((Decoder)dec);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void unRegister(CommHandle handler) {
        GeneralModule.getInstance().m_oCommMgr.getCommService().removeMessageListener(listenerCmdCode, (MSGListener)this.msgListener);
    }

    class ProgressMSGListener
    extends MSGReceiver {
        ProgressMSGListener() {
        }

        public void timeout(int cmdCode, Character cmdHandle) {
        }

        protected void processMessage(MSGPacketExt msgpacketext) {
            int cmdCode = msgpacketext.mheader.cmdCode;
            if (listenerCmdCode == cmdCode) {
                AsnProgressReport asnProgressReport = new AsnProgressReport();
                if (!DefaultProgressReporter.receiveNoticeDecode(msgpacketext, asnProgressReport)) {
                    DebugTracer.traceError((String)"Decode failed.");
                    return;
                }
                try {
                    ProgressListener listener = (ProgressListener)DefaultProgressReporter.this.progressListenerMap.get(asnProgressReport.missionID);
                    if (null != listener) {
                        int lastValue;
                        int progressID = asnProgressReport.missionID.intValue();
                        int value = asnProgressReport.progress.intValue();
                        if (value <= (lastValue = ((BigInteger)DefaultProgressReporter.this.valueMap.get(asnProgressReport.missionID)).intValue())) {
                            DebugTracer.traceError((String)"\u4e0a\u62a5\u7684\u8fdb\u5ea6\u4e0d\u5408\u7406\uff0c\u4e22\u5f03\u4e0d\u5904\u7406.");
                            return;
                        }
                        lastValue = value;
                        if (lastValue >= 100) {
                            lastValue = 0;
                        }
                        DefaultProgressReporter.this.valueMap.put(asnProgressReport.missionID, BigInteger.valueOf(lastValue));
                        String description = null;
                        description = null != asnProgressReport.processInfo ? new String(asnProgressReport.processInfo) : GeneralResourceManager.getInstance().getString("TaskDiscription");
                        AsnProgressDetailList asnProgressDetailList = asnProgressReport.detailList;
                        ProgressDetailInfo[] detailInfos = null;
                        if (null != asnProgressDetailList) {
                            Enumeration enumeration = asnProgressDetailList.elements();
                            int size = asnProgressDetailList.size();
                            detailInfos = new ProgressDetailInfo[size];
                            int i = 0;
                            while (enumeration.hasMoreElements()) {
                                AsnProgressDetail element = (AsnProgressDetail)enumeration.nextElement();
                                String strKey = new String(element.detailKey);
                                String strValue = new String(element.detailValue);
                                String strMemo = new String(element.detailMemo);
                                detailInfos[i] = new ProgressDetailInfo(strKey, strValue, strMemo);
                                ++i;
                            }
                        }
                        ProgressEvent event = new ProgressEvent(progressID, value, description, detailInfos);
                        listener.progressChange(event);
                    }
                }
                catch (Exception e) {
                    DebugTracer.trace((Exception)e);
                }
            }
        }
    }
}

