/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.progress;

import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.imap.general.progress.AbstractProgressMsgDisplayer;
import com.swimap.imap.general.progress.ProgressDetailInfo;
import com.swimap.imap.general.progress.ProgressDlg;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DefaultProgressMsgDisplayer
extends AbstractProgressMsgDisplayer {
    private ProgressDlg progressDlg = null;
    private String[] columnNames = new String[]{GeneralResourceManager.getInstance().getString("Progress_Table_Name"), GeneralResourceManager.getInstance().getString("Progress_Table_Result"), GeneralResourceManager.getInstance().getString("Progress_Table_Memo")};

    public DefaultProgressMsgDisplayer() {
        this.progressDlg = new ProgressDlg();
        this.setTableModel();
        this.progressDlg.setProgressMsgDisplayer(this);
    }

    @Override
    public void close() {
        if (null != this.progressDlg) {
            this.progressDlg.setProgressMsgDisplayer(null);
            this.progressDlg.getCancelBtn().setText(GeneralResourceManager.getInstance().getString("Button_Close"));
        }
    }

    @Override
    public void setTitle(String title) {
        if (null != this.progressDlg) {
            this.progressDlg.setTitle(title);
        }
    }

    @Override
    public void show() {
        this.progressDlg.getProgressBar().setValue(0);
        ScreenToolKit.centerLocateToScreen((Component)this.progressDlg);
        this.progressDlg.show();
    }

    @Override
    public void updateProgress(int value, String description, ProgressDetailInfo[] detailInfos) {
        this.progressDlg.getProgressBar().setValue(value);
        this.progressDlg.getProgressLabel().setText(description);
        if (null != detailInfos) {
            Vector vctTemp = new Vector();
            for (int i = 0; i < detailInfos.length; ++i) {
                Vector<String> rowData = new Vector<String>(3);
                rowData.add(detailInfos[i].getKey());
                rowData.add(detailInfos[i].getValue());
                rowData.add(detailInfos[i].getDescription());
                vctTemp.add(rowData);
            }
            this.addMultiData(vctTemp, (DefaultTableModel)this.progressDlg.getTableModel());
        }
    }

    private void addMultiData(Vector data, DefaultTableModel tableModel) {
        if (null == data || null == tableModel) {
            return;
        }
        Vector<Vector> vctTemp = tableModel.getDataVector();
        vctTemp.addAll(data);
        tableModel.fireTableRowsInserted(0, vctTemp.size() - 1);
    }

    @Override
    public void setTableModel() {
        if (null != this.progressDlg) {
            SortableTableModel tableModel = new SortableTableModel((Object[])this.columnNames, 0);
            this.progressDlg.getDetailTable().setModel((TableModel)tableModel);
            this.progressDlg.getDetailTable().setSortableClickCount(1);
            int count = this.progressDlg.getDetailTable().getTableHeader().getColumnModel().getColumnCount();
            for (int i = 0; i < count; ++i) {
                this.progressDlg.getDetailTable().setColumnSortable(i, true);
            }
        }
    }
}

