/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.dump.ui;

import com.swimap.external.common.adapter.message.util.EmfDialog;
import com.swimap.external.common.adapter.message.util.EmfOptionPane;
import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.imap.general.dump.ui.DumpTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeDialog
extends EmfDialog {
    protected GeneralResourceManager res = GeneralResourceManager.getInstance();
    protected static final String ACTION_DEL_ALL = "Del_All_File";
    protected static final String ACTION_DEFAULT = "Restore_Default";
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel contentPane = new JPanel();
    protected JSplitPane splitPane = new JSplitPane();
    protected JScrollPane leftPane = new JScrollPane();
    protected JPanel rightPane = new JPanel();
    protected JTree typeTree = null;
    protected JButton delAllButton = new JButton(this.res.getString("Del_All_Dump"));
    protected JButton defaultButton = new JButton(this.res.getString("Set_Default"));
    protected TreeSelectionListener treeListner = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath oPath = e.getNewLeadSelectionPath();
            if (oPath == null) {
                return;
            }
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oPath.getLastPathComponent();
            TreeDialog.this.switchPanel(oNode);
        }
    };

    public TreeDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    protected void init() {
        this.initContent();
        this.addListener();
        this.initData();
        this.setNames();
    }

    protected void initContent() {
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(11, 9, 0, 9));
        this.rightPane.setLayout(this.cardLayout);
        this.typeTree = new JTree(){

            @Override
            public void collapsePath(TreePath treePath) {
                if (treePath != null && treePath.getLastPathComponent() == this.getModel().getRoot()) {
                    return;
                }
                super.collapsePath(treePath);
            }

            @Override
            public void setSelectionInterval(int iStartRow, int iEndRow) {
                if (iStartRow == iEndRow && iStartRow == 0) {
                    return;
                }
                super.setSelectionInterval(iStartRow, iEndRow);
            }

            @Override
            public void setSelectionPath(TreePath treePath) {
                if (treePath != null && treePath.getLastPathComponent() == TreeDialog.this.typeTree.getModel().getRoot()) {
                    return;
                }
                super.setSelectionPath(treePath);
            }
        };
        this.typeTree.setCellRenderer(new DumpTreeCellRenderer());
        this.typeTree.getSelectionModel().setSelectionMode(1);
        this.leftPane.getViewport().add(this.typeTree);
        this.splitPane.setLeftComponent(this.leftPane);
        this.splitPane.setRightComponent(this.rightPane);
        this.splitPane.setDividerLocation(150);
        this.contentPane.add(this.splitPane);
        this.delAllButton.setActionCommand(ACTION_DEL_ALL);
        this.defaultButton.setActionCommand(ACTION_DEFAULT);
        this.delAllButton.setMnemonic('D');
        this.defaultButton.setMnemonic('F');
    }

    protected void setNames() {
        super.setName(((Object)((Object)this)).getClass().getName());
        this.typeTree.setName(((Object)((Object)this)).getClass().getName() + ".typeTree");
        this.leftPane.setName(((Object)((Object)this)).getClass().getName() + ".leftPane");
        this.rightPane.setName(((Object)((Object)this)).getClass().getName() + ".rightPane");
        this.contentPane.setName(((Object)((Object)this)).getClass().getName() + ".contentPane");
        this.delAllButton.setName(((Object)((Object)this)).getClass().getName() + ".delAllButton");
        this.defaultButton.setName(((Object)((Object)this)).getClass().getName() + ".defaultButton");
    }

    protected void removeListener() {
        this.delAllButton.removeActionListener(this.actionListener);
        this.defaultButton.removeActionListener(this.actionListener);
        this.typeTree.removeTreeSelectionListener(this.treeListner);
    }

    protected void addListener() {
        this.delAllButton.addActionListener(this.actionListener);
        this.defaultButton.addActionListener(this.actionListener);
        this.typeTree.addTreeSelectionListener(this.treeListner);
    }

    protected Component getContentPanel() {
        return this.contentPane;
    }

    protected boolean confirmAction(String action) {
        String message = this.res.getString("Confirm_Action", this.res.getString(action).toLowerCase());
        if (ACTION_DEL_ALL.equals(action)) {
            message = this.res.getString("Delete_All_Dump_File_Confirm");
        }
        return EmfOptionPane.showConfirmDialog((Component)((Object)this), (String)message) == 0;
    }

    public void dispose() {
        this.rightPane.removeAll();
        this.leftPane.removeAll();
        this.removeListener();
        super.dispose();
    }

    protected abstract void switchPanel(DefaultMutableTreeNode var1);

    protected abstract void initData();
}

