/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.dump.ui;

import com.swimap.external.common.adapter.message.util.EmfCommonLimitTextField;
import com.swimap.external.common.adapter.message.util.EmfOptionPane;
import com.swimap.external.common.adapter.message.util.GuiUtils;
import com.swimap.external.general.adapter.message.EmfManualDumpPanelInterface;
import com.swimap.imap.common.commoninterface.general.EmfProgressBarInterface;
import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.imap.general.GeneralUtils;
import com.swimap.imap.general.dump.DumpConstants;
import com.swimap.imap.general.dump.data.ManualDumpSetInfo;
import com.swimap.imap.general.dump.data.ManualDumpSetInfoEx;
import com.swimap.imap.general.progress.ProgressEvent;
import com.swimap.imap.general.progress.SimpleProgressTask;
import com.swimap.imap12.util.dateChooser.InmDateChooser;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.communicate.CommService;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class ManualDumpPanel
extends JPanel
implements EmfManualDumpPanelInterface,
EmfProgressBarInterface {
    private static final String AUTOTEST_PREFIX = "com.swimap.imap.general.dump.ui.ManualDumpPanel.";
    public static final String NO_QUERY = "";
    protected GeneralResourceManager res = GeneralResourceManager.getInstance();
    protected JButton dumpBtn = new JButton();
    protected JButton queryBtn = new JButton();
    protected JButton delBtn = new JButton();
    protected JLabel filePathLabel = new JLabel();
    protected JLabel fileFormatLabel = new JLabel();
    protected JLabel recordCountLabel = new JLabel();
    protected JLabel progressLabel = new JLabel();
    protected JCheckBox startTimeCheckBox = new JCheckBox();
    protected JCheckBox endTimeCheckBox = new JCheckBox();
    protected JTextField pathText = new EmfCommonLimitTextField(500, "~`!@#$%^&*(){[}]|;'\"<,>?\uff5e\u00b7\uff01\u25ce\uff03\uffe5\uff05\u2026\u2026\u203b\u00d7\uff08\uff09\u300e\u3010\u300f\u3011\u00f7\u00a7\uff1a\uff1b\u2018\u201c\u201d\u300a\uff0c\u300b\u3002\uff1f\u3001"){

        public void setText(String t) {
            super.setText(t);
            String text = this.getText();
            if (text != null) {
                text = ManualDumpPanel.NO_QUERY.equals(text.trim()) ? null : text;
            }
            this.setToolTipText(text);
        }

        public JToolTip createToolTip() {
            MultiRowToolTip tip = new MultiRowToolTip();
            tip.setComponent((JComponent)((Object)this));
            return tip;
        }
    };
    protected JComboBox fileFormatsCombo = new JComboBox<String>(DumpConstants.FILE_FORMATS);
    protected JTextField recordCountText = new EmfCommonLimitTextField(254, "~`!@#$%^&*(){[}]|;'\"<,>?\uff5e\u00b7\uff01\u25ce\uff03\uffe5\uff05\u2026\u2026\u203b\u00d7\uff08\uff09\u300e\u3010\u300f\u3011\u00f7\u00a7\uff1a\uff1b\u2018\u201c\u201d\u300a\uff0c\u300b\u3002\uff1f\u3001");
    protected InmDateChooser startTimeChooser = new InmDateChooser();
    protected InmDateChooser endTimeChooser = new InmDateChooser();
    protected JProgressBar progressBar = new JProgressBar();
    protected JPanel filePanel = new JPanel();
    protected JPanel timePanel = new JPanel();
    protected JPanel queryPanel = new JPanel();
    protected JPanel progressPanel = new JPanel();
    protected JPanel operatePanel = new JPanel();
    protected TitledBorder queryTimeBorder;
    protected ActionListener actionListener = null;
    protected DocumentListener documentListener = null;
    protected ActionListener btnActionListener = null;
    protected static final String ACTION_QUERY = "ACTION_QUERY";
    protected static final String ACTION_DUMP = "ACTION_DUMP";
    protected static final String ACTION_DEL = "Del_Dump_File";
    protected boolean bIsFirst = true;
    protected int missionID = -1;
    protected SimpleProgressTask progressTask = null;
    private int timeout = 180000;

    public ManualDumpPanel() {
        this(new ManualDumpSetInfo());
    }

    public ManualDumpPanel(ManualDumpSetInfo setting) {
        this.setTexts();
        this.jbInit();
        this.initListeners();
        this.setNames();
    }

    public int dispose() {
        this.startTimeCheckBox.removeActionListener(this.actionListener);
        this.endTimeCheckBox.removeActionListener(this.actionListener);
        this.fileFormatsCombo.removeActionListener(this.actionListener);
        this.actionListener = null;
        this.pathText.getDocument().removeDocumentListener(this.documentListener);
        this.startTimeChooser.getTextField().getDocument().removeDocumentListener(this.documentListener);
        this.endTimeChooser.getTextField().getDocument().removeDocumentListener(this.documentListener);
        this.documentListener = null;
        this.queryBtn.removeActionListener(this.btnActionListener);
        this.dumpBtn.removeActionListener(this.btnActionListener);
        this.delBtn.removeActionListener(this.btnActionListener);
        this.btnActionListener = null;
        if (this.progressTask != null) {
            this.progressTask.close();
            this.progressTask = null;
        }
        return 0;
    }

    protected void jbInit() {
        this.setLayout(new BorderLayout());
        Border border = BorderFactory.createEtchedBorder(Color.white, DumpConstants.BORDER_COLOR);
        this.setBorder(border);
        JPanel tempP = new JPanel();
        tempP.setLayout(new GridBagLayout());
        this.initFilePanel();
        this.initTimePanel();
        this.initQueryPanel();
        this.initProgressBarPanel();
        this.initOperPanel();
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.25, 18, 2, new Insets(11, 9, 0, 9), 0, 0);
        tempP.add((Component)this.filePanel, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.25, 18, 2, new Insets(11, 9, 0, 9), 0, 0);
        tempP.add((Component)this.timePanel, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.25, 18, 2, new Insets(11, 9, 0, 9), 0, 0);
        tempP.add((Component)this.queryPanel, constraints);
        this.add((Component)tempP, "North");
        this.add((Component)this.progressPanel, "Center");
        this.add((Component)this.operatePanel, "South");
        this.setProgressBarVisible(false);
    }

    protected void initFilePanel() {
        TitledBorder border = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, DumpConstants.BORDER_COLOR), this.res.getString("File"));
        this.filePanel.setBorder(border);
        this.filePanel.setLayout(new GridBagLayout());
        this.pathText.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0);
        this.filePanel.add((Component)this.filePathLabel, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0);
        this.filePanel.add((Component)this.pathText, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0);
        this.filePanel.add((Component)this.fileFormatLabel, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0);
        this.filePanel.add((Component)this.fileFormatsCombo, constraints);
        GuiUtils.setPreferredHeight((Component[])new Component[]{this.pathText, this.fileFormatsCombo}, (int)20);
    }

    protected void initTimePanel() {
        String strBorderTitle = NO_QUERY;
        strBorderTitle = ResourceMng.getInstance().getLocale().getLanguage().toUpperCase().equals("ZH") ? this.getTitle() + this.res.getString("LOG_DATE") : this.res.getString("LOG_DATE") + this.getTitle();
        this.queryTimeBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, DumpConstants.BORDER_COLOR), strBorderTitle);
        this.timePanel.setBorder(this.queryTimeBorder);
        this.timePanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0);
        this.startTimeChooser.setYearRange(1971, 2037);
        this.endTimeChooser.setYearRange(1971, 2037);
        this.timePanel.add((Component)this.startTimeCheckBox, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0);
        this.timePanel.add((Component)this.startTimeChooser, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0);
        this.timePanel.add((Component)this.endTimeCheckBox, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0);
        this.timePanel.add((Component)this.endTimeChooser, constraints);
    }

    protected void initQueryPanel() {
        TitledBorder border = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, DumpConstants.BORDER_COLOR), this.res.getString("LOG_FITED"));
        this.queryPanel.setBorder(border);
        this.queryPanel.setLayout(new GridBagLayout());
        this.recordCountText.setPreferredSize(new Dimension(80, 21));
        this.queryBtn.setMaximumSize(new Dimension(85, 21));
        this.queryBtn.setMinimumSize(new Dimension(85, 21));
        this.recordCountText.setText(NO_QUERY);
        this.recordCountText.setEnabled(false);
        this.queryPanel.add((Component)this.recordCountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.recordCountText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 7, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.queryBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 7, 0, 0), 0, 0));
    }

    protected void initProgressBarPanel() {
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(this.progressBar.getPreferredSize().width, 21));
        this.progressPanel.setLayout(new GridBagLayout());
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(11, 9, 0, 9));
        this.progressPanel.add((Component)this.progressLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 2, 3, 2), 0, 0));
        this.progressPanel.add((Component)this.progressBar, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void initOperPanel() {
        this.operatePanel.setLayout(new FlowLayout(2, 4, 12));
        this.operatePanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.operatePanel.add(this.delBtn);
        this.operatePanel.add(this.dumpBtn);
    }

    protected void setTexts() {
        this.dumpBtn.setText(this.res.getString("DUMP"));
        this.queryBtn.setText(this.res.getString("QUERY"));
        this.delBtn.setText(this.res.getString("DEL_LOGFILE"));
        this.dumpBtn.setActionCommand(ACTION_DUMP);
        this.queryBtn.setActionCommand(ACTION_QUERY);
        this.delBtn.setActionCommand(ACTION_DEL);
        this.dumpBtn.setMnemonic('U');
        this.queryBtn.setMnemonic('Q');
        this.delBtn.setMnemonic('L');
        GuiUtils.formatButtons((JButton[])new JButton[]{this.delBtn, this.queryBtn, this.dumpBtn});
        this.filePathLabel.setText(this.res.getString("StoreFileName"));
        this.fileFormatLabel.setText(this.res.getString("StoreFileFormat"));
        this.startTimeCheckBox.setText(this.res.getString("DUMP_START_TIME"));
        this.endTimeCheckBox.setText(this.res.getString("DUMP_END_TIME"));
        this.recordCountLabel.setText(this.res.getString("DUMP_RECORDCOUNT"));
        this.progressLabel.setText(this.res.getString("DUMP_PROGRESS_STATUS"));
    }

    private void setNames() {
        this.dumpBtn.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.dumpBtn");
        this.queryBtn.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.queryBtn");
        this.delBtn.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.delBtn");
        this.filePathLabel.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.filePathLabel");
        this.fileFormatLabel.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.fileFormatLabel");
        this.recordCountLabel.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.recordCountLabel");
        this.progressLabel.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.progressLabel");
        this.startTimeCheckBox.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.startTimeCheckBox");
        this.endTimeCheckBox.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.endTimeCheckBox");
        this.pathText.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.pathText");
        this.fileFormatsCombo.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.fileFormatsCombo");
        this.recordCountText.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.recordCountText");
        this.startTimeChooser.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.startTimeChooser");
        this.endTimeChooser.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.endTimeChooser");
        this.progressBar.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.progressBar");
        this.filePanel.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.filePanel");
        this.timePanel.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.timePanel");
        this.queryPanel.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.queryPanel");
        this.progressPanel.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.progressPanel");
        this.operatePanel.setName("com.swimap.imap.general.dump.ui.ManualDumpPanel.operatePanel");
    }

    protected void initListeners() {
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualDumpPanel.this.fireContextChange();
                ManualDumpPanel.this.startTimeChooser.setEnabled(ManualDumpPanel.this.startTimeCheckBox.isSelected());
                ManualDumpPanel.this.endTimeChooser.setEnabled(ManualDumpPanel.this.endTimeCheckBox.isSelected());
            }
        };
        this.startTimeCheckBox.addActionListener(this.actionListener);
        this.endTimeCheckBox.addActionListener(this.actionListener);
        this.fileFormatsCombo.addActionListener(this.actionListener);
        this.documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ManualDumpPanel.this.fireContextChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ManualDumpPanel.this.fireContextChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ManualDumpPanel.this.fireContextChange();
            }
        };
        this.pathText.getDocument().addDocumentListener(this.documentListener);
        this.startTimeChooser.getTextField().getDocument().addDocumentListener(this.documentListener);
        this.endTimeChooser.getTextField().getDocument().addDocumentListener(this.documentListener);
        this.btnActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualDumpPanel.this.proccessAciton(e);
            }
        };
        this.queryBtn.addActionListener(this.btnActionListener);
        this.dumpBtn.addActionListener(this.btnActionListener);
        this.delBtn.addActionListener(this.btnActionListener);
    }

    protected void proccessAciton(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        GeneralLogger.trace("Current manual dump action command: " + actionCommand);
        if (ACTION_DUMP.equals(actionCommand)) {
            if (!this.checkParamValid()) {
                return;
            }
            if (this.confirmAction(actionCommand)) {
                this.doDump();
            }
        }
        if (ACTION_QUERY.equals(actionCommand)) {
            if (!this.checkParamValid()) {
                return;
            }
            int count = this.doQuery();
            this.recordCountText.setText(count < 0 ? NO_QUERY : Integer.toString(count));
        }
        if (ACTION_DEL.equals(actionCommand) && this.confirmAction(actionCommand)) {
            int sessionid = GeneralUtils.getSessionID();
            Vector vctErrorInfo = this.delAllDumpFile();
            String action = this.res.getString(ACTION_DEL);
            String msg = null;
            if (sessionid != GeneralUtils.getSessionID()) {
                GeneralLogger.error((String)"Error: Job finished in diff session");
                return;
            }
            if (null == vctErrorInfo || vctErrorInfo.size() == 0) {
                msg = this.res.getString("Action_Succeed", action);
                GeneralUtils.showNotification(msg);
            } else {
                msg = this.res.getString("Action_Failed", action);
                String strDefaultStr = this.getTitle() + ":" + action;
                vctErrorInfo = GeneralUtils.convertErrorInfo(strDefaultStr, vctErrorInfo);
                GeneralUtils.showResult(null, msg, vctErrorInfo);
            }
        }
    }

    protected boolean confirmAction(String action) {
        String message = this.res.getString("Confirm_Action", this.res.getString(action).toLowerCase());
        if (ACTION_DUMP.equals(action)) {
            message = this.res.getString("Dump_Confirm");
        } else if (ACTION_DEL.equals(action)) {
            message = this.res.getString("Delete_Dump_File_Confirm");
        }
        return EmfOptionPane.showYesNoExtConfirmDialog((Component)this, (String)message) == 0;
    }

    public boolean setDataInfo(ManualDumpSetInfo setting) {
        boolean rest = false;
        if (null != setting) {
            Calendar cal = Calendar.getInstance();
            Date date = null;
            boolean isStartSeled = setting.lStartTime >= 0L;
            boolean isEndSeled = setting.lEndTime >= 0L;
            this.pathText.setText(setting.strFilePath);
            this.startTimeCheckBox.setSelected(isStartSeled);
            this.endTimeCheckBox.setSelected(isEndSeled);
            if (isStartSeled) {
                date = new Date(setting.lStartTime);
                cal.setTime(date);
                this.startTimeChooser.setCalendar(cal);
                this.startTimeChooser.setEnabled(true);
            } else {
                date = new Date(System.currentTimeMillis() - 86400000L);
                cal.setTime(date);
                this.startTimeChooser.setCalendar(cal);
                this.startTimeChooser.setEnabled(false);
            }
            if (isEndSeled) {
                date = new Date(setting.lEndTime);
                cal.setTime(date);
                this.endTimeChooser.setCalendar(cal);
                this.endTimeChooser.setEnabled(true);
            } else {
                date = new Date(System.currentTimeMillis());
                cal.setTime(date);
                this.endTimeChooser.setCalendar(cal);
                this.endTimeChooser.setEnabled(false);
            }
            this.fileFormatsCombo.setSelectedItem(DumpConstants.getFormatByExt(setting.strFormat));
            this.recordCountText.setText(NO_QUERY);
            rest = true;
        }
        return rest;
    }

    public ManualDumpSetInfo getDataInfo() {
        ManualDumpSetInfo setting = new ManualDumpSetInfo();
        setting.strFilePath = this.pathText.getText();
        setting.strFormat = DumpConstants.getExtByFormat((String)this.fileFormatsCombo.getSelectedItem());
        if (this.startTimeCheckBox.isSelected()) {
            setting.lStartTime = this.startTimeChooser.getCalendar(true).getTimeInMillis();
            this.startTimeChooser.setCalendar(this.startTimeChooser.getCalendar(true));
        } else {
            setting.lStartTime = -1L;
        }
        if (this.endTimeCheckBox.isSelected()) {
            setting.lEndTime = this.endTimeChooser.getCalendar(true).getTimeInMillis();
            this.endTimeChooser.setCalendar(this.endTimeChooser.getCalendar(true));
        } else {
            setting.lEndTime = -1L;
        }
        return setting;
    }

    public ManualDumpSetInfoEx getDolDataInfo() {
        ManualDumpSetInfoEx setting = new ManualDumpSetInfoEx();
        setting.strFilePath = this.pathText.getText();
        setting.strFormat = DumpConstants.getExtByFormat((String)this.fileFormatsCombo.getSelectedItem());
        setting.lStartTime = this.startTimeCheckBox.isSelected() ? this.startTimeChooser.getCalendar(true) : null;
        setting.lEndTime = this.endTimeCheckBox.isSelected() ? this.endTimeChooser.getCalendar(true) : null;
        return setting;
    }

    protected void disablePanel() {
        boolean bEnable = false;
        this.dumpBtn.setEnabled(bEnable);
        this.queryBtn.setEnabled(bEnable);
        this.delBtn.setEnabled(bEnable);
        this.startTimeCheckBox.setEnabled(bEnable);
        this.endTimeCheckBox.setEnabled(bEnable);
        this.pathText.setEnabled(bEnable);
        this.fileFormatsCombo.setEnabled(bEnable);
        this.recordCountText.setEnabled(bEnable);
        this.startTimeChooser.setEnabled(bEnable);
        this.endTimeChooser.setEnabled(bEnable);
    }

    protected void fireContextChange() {
    }

    public int actived() {
        if (this.bIsFirst) {
            this.bIsFirst = false;
            this.setDataInfo(new ManualDumpSetInfo());
            this.pathText.setText(this.getPathText());
        }
        return 0;
    }

    public int deactived() {
        return 0;
    }

    public Container initContainer() {
        this.bIsFirst = true;
        return this;
    }

    public void setProgressBarVisible(final boolean bVisible) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManualDumpPanel.this.progressBar.setVisible(bVisible);
                    ManualDumpPanel.this.progressLabel.setVisible(bVisible);
                }
            });
        } else {
            this.progressBar.setVisible(bVisible);
            this.progressLabel.setVisible(bVisible);
        }
    }

    public void setProgressPercent(final int iPercent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManualDumpPanel.this.progressBar.setValue(iPercent);
                }
            });
        } else {
            this.progressBar.setValue(iPercent);
        }
    }

    protected void resetProgressBarStatus() {
        this.setProgressPercent(0);
        this.setProgressBarVisible(false);
    }

    protected boolean checkParamValid() {
        return true;
    }

    public int doDump() {
        this.dumpBtn.setEnabled(false);
        this.missionID = this.createMissionID();
        this.registerDumpProgressTask(this.getDumpCommService());
        if (!this.processDump(this.missionID)) {
            this.dumpBtn.setEnabled(true);
        }
        return 0;
    }

    protected boolean processDump(int missionID) {
        return false;
    }

    protected CommService getDumpCommService() {
        return null;
    }

    public void registerDumpProgressTask(CommService comm) {
        if (this.progressTask != null) {
            this.progressTask.startTask(comm);
        }
    }

    public void unregisterDumpProgressTask(CommService comm) {
        if (this.progressTask != null) {
            this.progressTask.stopTask();
            this.progressTask.close();
            this.progressTask = null;
        }
    }

    protected int createMissionID() {
        int moduleID = (int)Math.floor(Math.random() * 100.0);
        this.progressTask = new SimpleProgressTask(moduleID, this.timeout){

            @Override
            protected void handleTimeOut() {
                ManualDumpPanel.this.handleTimeOut();
            }

            @Override
            protected void updateProgressUI(ProgressEvent event) {
                ManualDumpPanel.this.setProgressBarVisible(true);
                ManualDumpPanel.this.setProgressPercent(event.getValue());
            }
        };
        return this.progressTask.getMissionID();
    }

    protected void handleTimeOut() {
    }

    protected int getDumpTimeOut() {
        return this.timeout;
    }

    public void reInitFirstFlag() {
        this.bIsFirst = true;
    }

    public abstract int doQuery();

    protected String getPathText() {
        return NO_QUERY;
    }
}

