/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.dump.ui;

import com.swimap.external.common.adapter.message.util.CommonUtilities;
import com.swimap.external.general.adapter.message.EmfManualDumpPanelInterface;
import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.dump.control.ManualDumpManager;
import com.swimap.imap.general.dump.data.ManualDumpLogType;
import com.swimap.imap.general.dump.ui.ManualDumpPanel;
import com.swimap.imap.general.dump.ui.TreeDialog;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ManualDumpDlg
extends TreeDialog {
    private EmfManualDumpPanelInterface currManualPanel = null;

    public ManualDumpDlg(Frame owner, boolean modal) {
        super(owner, modal);
        this.setTitle(this.res.getString("ManualDump"));
    }

    @Override
    protected void initData() {
        LinkedList types = ManualDumpManager.getInstance().getAllManualDumpType();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.res.getString("ManualDump"));
        DefaultTreeModel model = new DefaultTreeModel(root);
        ManualDumpLogType logtype2 = null;
        for (ManualDumpLogType logtype2 : types) {
            root.add(new DefaultMutableTreeNode(logtype2));
            this.rightPane.add((Component)logtype2.getManualDumpPanelInterface().initContainer(), logtype2.getID());
        }
        this.typeTree.setModel(model);
        try {
            if (root.children().hasMoreElements()) {
                TreePath path = new TreePath(((DefaultMutableTreeNode)root.getFirstChild()).getPath());
                this.typeTree.setSelectionPath(path);
            }
        }
        catch (Exception e) {
            GeneralLogger.error((String)"error while select the first node", (Throwable)e);
        }
    }

    protected void proccessActions(ActionEvent e) {
        String sActionCommand = e.getActionCommand();
        GeneralLogger.trace("Current manual dump action command: " + sActionCommand);
        if ("Del_All_File".equals(sActionCommand)) {
            if (this.confirmAction(sActionCommand)) {
                ManualDumpManager.getInstance().delAllDumpFile();
            }
        } else if ("Restore_Default".equals(sActionCommand)) {
            if (this.confirmAction(sActionCommand)) {
                ManualDumpManager.getInstance().restoreAllSetting();
            }
        } else if ("ACTION_CANCEL".equals(sActionCommand)) {
            this.setVisible(false);
        }
    }

    protected JButton[] getButtons() {
        this.cancelButton.setText(this.res.getString("Close"));
        JButton[] buttons = new JButton[]{this.delAllButton, this.defaultButton, this.cancelButton};
        CommonUtilities.bindDefaultKeyActions((JDialog)((Object)this), (JButton)this.cancelButton, (JButton)this.cancelButton);
        return buttons;
    }

    @Override
    protected void switchPanel(DefaultMutableTreeNode node) {
        if (node.isLeaf()) {
            Object userObj;
            if (null != this.currManualPanel) {
                this.currManualPanel.deactived();
            }
            if ((userObj = node.getUserObject()) instanceof ManualDumpLogType) {
                ManualDumpLogType type = (ManualDumpLogType)userObj;
                this.currManualPanel = type.getManualDumpPanelInterface();
                this.cardLayout.show(this.rightPane, type.getID());
                this.currManualPanel.actived();
            }
        }
        this.typeTree.requestFocus();
    }

    private void disposeAllManualPanels() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.typeTree.getModel().getRoot();
        Enumeration<TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            try {
                ManualDumpLogType type = (ManualDumpLogType)((DefaultMutableTreeNode)e.nextElement()).getUserObject();
                EmfManualDumpPanelInterface tmpManualPanel = type.getManualDumpPanelInterface();
                tmpManualPanel.dispose();
            }
            catch (Exception ex) {
                GeneralLogger.trace(ex);
            }
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            if (this.currManualPanel != null) {
                this.currManualPanel.actived();
            } else {
                Object userObj;
                TreePath path = this.typeTree.getSelectionPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node.isLeaf() && (userObj = node.getUserObject()) instanceof ManualDumpLogType) {
                    ManualDumpLogType type = (ManualDumpLogType)userObj;
                    this.currManualPanel = type.getManualDumpPanelInterface();
                    this.currManualPanel.actived();
                }
            }
            ScreenToolKit.centerLocateToScreen((Component)((Object)this));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManualDumpDlg.this.splitPane.setDividerLocation(150);
                }
            });
        } else {
            this.reInitPanelFirstOpenFlag();
        }
        super.setVisible(b);
    }

    @Override
    public void dispose() {
        this.disposeAllManualPanels();
        this.currManualPanel = null;
        super.dispose();
    }

    private void reInitPanelFirstOpenFlag() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.typeTree.getModel().getRoot();
        Enumeration<TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            try {
                ManualDumpLogType type = (ManualDumpLogType)((DefaultMutableTreeNode)e.nextElement()).getUserObject();
                ManualDumpPanel tmpManualPanel = (ManualDumpPanel)type.getManualDumpPanelInterface();
                tmpManualPanel.reInitFirstFlag();
            }
            catch (Exception ex) {
                GeneralLogger.trace(ex);
            }
        }
    }
}

