/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.dump.ui;

import com.swimap.external.common.adapter.message.util.EmfCommonLimitTextField;
import com.swimap.external.common.adapter.message.util.EmfNumericSpinner;
import com.swimap.external.common.adapter.message.util.GuiUtils;
import com.swimap.external.general.adapter.message.EmfDumpSetListener;
import com.swimap.external.general.adapter.message.EmfDumpSettingInterface;
import com.swimap.external.general.adapter.message.ParamModifyEvent;
import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.imap.general.dump.DumpConstants;
import com.swimap.imap.general.dump.data.DumpSetInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class DumpSetPanel
extends JPanel
implements EmfDumpSettingInterface {
    protected GeneralResourceManager res = GeneralResourceManager.getInstance();
    protected JPanel jPanelOverFlow = new JPanel();
    protected JPanel jPanePeriod = new JPanel();
    protected JPanel jPanelPathSetting = new JPanel();
    protected JLabel jLabelMax = new JLabel();
    protected JLabel jLabelDumpRatio = new JLabel();
    protected JLabel jLabelOverflowRatio = new JLabel();
    protected JLabel isPeriodLabel = new JLabel();
    protected JLabel jLabelPeriodInterval = new JLabel();
    protected JLabel jLabelPeriodEndTime = new JLabel();
    protected JLabel JLabelDaysOfLog = new JLabel();
    protected JLabel jLabelFileFormat = new JLabel();
    protected JLabel fileFormatLabel = new JLabel();
    protected JLabel jLabelDumpPath = new JLabel();
    protected EmfNumericSpinner txtMaxCapacity = new EmfNumericSpinner(1, 300000);
    protected EmfNumericSpinner txtDumpRatio = new EmfNumericSpinner(16, 100);
    protected EmfNumericSpinner txtOverflowRatio = new EmfNumericSpinner(16, 100);
    protected EmfNumericSpinner txtDumpInterval = new EmfNumericSpinner(8, 90);
    protected EmfNumericSpinner txtPeriodEndTime = new EmfNumericSpinner(8, 90);
    protected JComboBox isPeriodComboBox = new JComboBox<String>(new String[]{DumpConstants.YES, DumpConstants.NO});
    protected JComboBox jCboFileFormat = new JComboBox<String>(DumpConstants.FILE_FORMATS);
    protected JComboBox jCboDumpTo = new JComboBox<String>(DumpConstants.DUMP_DEST);
    protected JTextField jTxtDumpPath = new EmfCommonLimitTextField(254, "~`!@#$%^&*(){[}]|;'\"<,>?\uff5e\u00b7\uff01\u25ce\uff03\uffe5\uff05\u2026\u2026\u203b\u00d7\uff08\uff09\u300e\u3010\u300f\u3011\u00f7\u00a7\uff1a\uff1b\u2018\u201c\u201d\u300a\uff0c\u300b\u3002\uff1f\u3001");
    protected boolean bDirty = false;
    protected boolean bShowOverflowRatio = true;
    protected ChangeListener _oValueChange = null;
    protected ActionListener commonActionListen = null;
    protected ItemListener isPeriodListener = null;
    protected ActionListener dumpToActionListen = null;
    protected DocumentListener documentListener = null;
    protected Vector vctDumpsetListener = new Vector();
    protected boolean bIsFirst = true;

    public DumpSetPanel(boolean bShowOverflowRatio) {
        this((DumpSetInfo)null, bShowOverflowRatio);
    }

    public DumpSetPanel(DumpSetInfo tmpInfo, boolean bShowOverflowRatio) {
        this.bShowOverflowRatio = bShowOverflowRatio;
        this.setTexts();
        this.jbInit();
        this.setDataInfo(tmpInfo);
        this.initListeners();
        this.setNames();
    }

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(Color.white, DumpConstants.BORDER_COLOR);
        this.setBorder(border);
        this.add((Component)this.getJPanelOverFlow(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.25, 11, 2, new Insets(0, 6, 4, 6), 0, 0));
        this.add((Component)this.getJPanePeriod(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.375, 11, 2, new Insets(0, 6, 4, 6), 0, 0));
        this.add((Component)this.initPathSetting(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.375, 11, 2, new Insets(0, 6, 4, 6), 0, 0));
        this.setPeriodState(false);
    }

    protected void setTexts() {
        this.jLabelMax.setText(this.res.getString("Dump_Max_Capacity"));
        this.jLabelDumpRatio.setText(this.res.getString("Dump_Capacity_Ratio"));
        this.jLabelOverflowRatio.setText(this.res.getString("Dump_Overflow_Ratio"));
        this.isPeriodLabel.setText(this.res.getString("Dump_Is_Periodically"));
        this.jLabelPeriodInterval.setText(this.res.getString("Dump_Period_Interval"));
        this.jLabelPeriodEndTime.setText(this.res.getString("Keep_Latest"));
        this.JLabelDaysOfLog.setText(this.res.getString("Day_Of_logs"));
        this.fileFormatLabel.setText(this.res.getString("Dump_File_Format"));
        this.jLabelFileFormat.setText(this.res.getString("Dump_Style"));
        this.jLabelDumpPath.setText(this.res.getString("Dump_Path"));
    }

    private void setNames() {
        this.jLabelMax.setName(this.getClass().getName() + ".jLabelMax");
        this.jLabelDumpRatio.setName(this.getClass().getName() + ".jLabelDumpRatio");
        this.jLabelOverflowRatio.setName(this.getClass().getName() + ".jLabelOverflowRatio");
        this.isPeriodLabel.setName(this.getClass().getName() + ".isPeriodLabel");
        this.jLabelPeriodInterval.setName(this.getClass().getName() + ".jLabelPeriodInterval");
        this.jLabelPeriodEndTime.setName(this.getClass().getName() + ".jLabelPeriodEndTime");
        this.JLabelDaysOfLog.setName(this.getClass().getName() + ".JLabelDaysOfLog");
        this.fileFormatLabel.setName(this.getClass().getName() + ".fileFormatLabel");
        this.jLabelFileFormat.setName(this.getClass().getName() + ".jLabelFileFormat");
        this.jLabelDumpPath.setName(this.getClass().getName() + ".jLabelDumpPath");
        this.txtMaxCapacity.setName(this.getClass().getName() + ".txtMaxCapacity");
        this.txtDumpRatio.setName(this.getClass().getName() + ".txtDumpRatio");
        this.txtOverflowRatio.setName(this.getClass().getName() + ".txtOverflowRatio");
        this.txtDumpInterval.setName(this.getClass().getName() + ".txtDumpInterval");
        this.txtPeriodEndTime.setName(this.getClass().getName() + ".txtPeriodEndTime");
        this.isPeriodComboBox.setName(this.getClass().getName() + ".isPeriodComboBox");
        this.jCboFileFormat.setName(this.getClass().getName() + ".jCboFileFormat");
        this.jCboDumpTo.setName(this.getClass().getName() + ".jCboDumpTo");
        this.jTxtDumpPath.setName(this.getClass().getName() + ".jTxtDumpPath");
    }

    protected void initListeners() {
        this._oValueChange = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DumpSetPanel.this.fireValueChange();
            }
        };
        this.commonActionListen = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DumpSetPanel.this.fireValueChange();
            }
        };
        this.isPeriodListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DumpSetPanel.this.fireValueChange();
                DumpSetPanel.this.resetPeriodState();
            }
        };
        this.dumpToActionListen = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DumpSetPanel.this.fireValueChange();
                DumpSetPanel.this.updateDumpPathState();
            }
        };
        this.documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DumpSetPanel.this.fireValueChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DumpSetPanel.this.fireValueChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DumpSetPanel.this.fireValueChange();
            }
        };
        this.addChangeLister(true);
    }

    protected JPanel initPathSetting() {
        this.jPanelPathSetting.setBorder(new MyTitleBorder(this.res.getString("Dump_Setting")));
        this.jPanelPathSetting.setLayout(new GridBagLayout());
        this.jPanelPathSetting.add((Component)this.jLabelFileFormat, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0));
        this.jCboDumpTo.setMinimumSize(new Dimension(122, 20));
        this.jCboDumpTo.setPreferredSize(new Dimension(122, 20));
        this.jPanelPathSetting.add((Component)this.jCboDumpTo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0));
        this.jPanelPathSetting.add((Component)this.fileFormatLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0));
        this.jCboFileFormat.setMinimumSize(new Dimension(122, 20));
        this.jCboFileFormat.setPreferredSize(new Dimension(122, 20));
        this.jPanelPathSetting.add((Component)this.jCboFileFormat, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0));
        this.jPanelPathSetting.add((Component)this.jLabelDumpPath, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0));
        this.jTxtDumpPath.setEnabled(false);
        this.jPanelPathSetting.add((Component)this.jTxtDumpPath, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0));
        GuiUtils.setPreferredHeight((Component[])new Component[]{this.jCboFileFormat, this.jCboDumpTo, this.jTxtDumpPath}, (int)20);
        return this.jPanelPathSetting;
    }

    protected JPanel getJPanelOverFlow() {
        this.jPanelOverFlow = new JPanel();
        this.jPanelOverFlow.setBorder(new MyTitleBorder(this.res.getString("Dump_When_Overflow")));
        this.jPanelOverFlow.setLayout(new GridBagLayout());
        this.jPanelOverFlow.add((Component)this.jLabelMax, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0));
        this.jPanelOverFlow.add((Component)this.txtMaxCapacity, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 0), 0, 0));
        this.jPanelOverFlow.add((Component)this.jLabelDumpRatio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0));
        this.jPanelOverFlow.add((Component)this.txtDumpRatio, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 0), 0, 0));
        if (this.bShowOverflowRatio) {
            this.jPanelOverFlow.add((Component)this.jLabelOverflowRatio, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0));
            this.jPanelOverFlow.add((Component)this.txtOverflowRatio, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 0), 0, 0));
        }
        GuiUtils.setPreferredHeight((Component[])new Component[]{this.txtMaxCapacity, this.txtDumpRatio, this.txtOverflowRatio}, (int)20);
        return this.jPanelOverFlow;
    }

    protected JPanel getJPanePeriod() {
        this.jPanePeriod = new JPanel();
        this.jPanePeriod.setLayout(new GridBagLayout());
        this.jPanePeriod.setBorder(new MyTitleBorder(this.res.getString("Dump_Periodically")));
        this.txtPeriodEndTime.setPreferredSize(new Dimension(80, 20));
        this.jPanePeriod.add((Component)this.isPeriodLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0));
        this.isPeriodComboBox.setMinimumSize(new Dimension(122, 20));
        this.isPeriodComboBox.setPreferredSize(new Dimension(122, 20));
        this.jPanePeriod.add((Component)this.isPeriodComboBox, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0));
        this.jPanePeriod.add((Component)this.jLabelPeriodInterval, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 5, 3, 5), 0, 0));
        this.jPanePeriod.add((Component)this.txtDumpInterval, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0));
        JPanel tempPnl = new JPanel();
        tempPnl.setLayout(new FlowLayout(0));
        tempPnl.add(this.jLabelPeriodEndTime);
        tempPnl.add((Component)this.txtPeriodEndTime);
        tempPnl.add(this.JLabelDaysOfLog);
        this.jPanePeriod.add((Component)tempPnl, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 3, 5), 0, 0));
        GuiUtils.setPreferredHeight((Component[])new Component[]{this.isPeriodComboBox, this.txtDumpInterval, this.txtPeriodEndTime}, (int)20);
        return this.jPanePeriod;
    }

    public boolean setDataInfo(DumpSetInfo tmpInfo) {
        if (null == tmpInfo) {
            return false;
        }
        this.bIsFirst = false;
        this.txtMaxCapacity.setValue((Object)BigInteger.valueOf(tmpInfo.nMaxCapacity));
        this.txtDumpRatio.setValue((Object)BigInteger.valueOf(tmpInfo.nDumpRatio));
        this.txtOverflowRatio.setValue((Object)BigInteger.valueOf(tmpInfo.nOverflowRatio));
        this.isPeriodComboBox.setSelectedItem(tmpInfo.bNeedPeriodDump ? DumpConstants.YES : DumpConstants.NO);
        this.setPeriodState(tmpInfo.bNeedPeriodDump);
        this.txtDumpInterval.setValue((Object)BigInteger.valueOf(tmpInfo.nPeriodInterval));
        this.txtPeriodEndTime.setValue((Object)BigInteger.valueOf(tmpInfo.nPeriodEndTime));
        this.jCboFileFormat.setSelectedItem(DumpConstants.getFormatByExt(tmpInfo.strFileFormat));
        this.jCboDumpTo.setSelectedIndex(tmpInfo.nDumpSetIndex);
        String strDumpPath = "";
        if (null != tmpInfo.strDumpPath && (strDumpPath = tmpInfo.strDumpPath).length() > 254) {
            strDumpPath = strDumpPath.substring(0, 254);
        }
        this.jTxtDumpPath.setText(strDumpPath);
        return true;
    }

    public DumpSetInfo getDataInfo() {
        DumpSetInfo tmpInfo = new DumpSetInfo();
        tmpInfo.nMaxCapacity = this.txtMaxCapacity.getBigIntegerValue().longValue();
        tmpInfo.nDumpRatio = this.txtDumpRatio.getBigIntegerValue().longValue();
        tmpInfo.nOverflowRatio = this.txtOverflowRatio.getBigIntegerValue().longValue();
        tmpInfo.bNeedPeriodDump = DumpConstants.YES.equals(this.isPeriodComboBox.getSelectedItem());
        tmpInfo.nPeriodInterval = this.txtDumpInterval.getBigIntegerValue().longValue();
        tmpInfo.nPeriodEndTime = this.txtPeriodEndTime.getBigIntegerValue().longValue();
        tmpInfo.strDumpPath = this.jTxtDumpPath.getText().trim();
        tmpInfo.strFileFormat = DumpConstants.getExtByFormat((String)this.jCboFileFormat.getSelectedItem());
        tmpInfo.nDumpSetIndex = this.jCboDumpTo.getSelectedIndex();
        return tmpInfo;
    }

    protected void setPeriodState(boolean bSelected) {
        this.txtDumpInterval.setEnabled(bSelected);
        this.txtPeriodEndTime.setEnabled(bSelected);
    }

    protected void resetPeriodState() {
        boolean isPeriod = DumpConstants.YES.equals(this.isPeriodComboBox.getSelectedItem());
        this.txtDumpInterval.setEnabled(isPeriod);
        this.txtPeriodEndTime.setEnabled(isPeriod);
    }

    public int dispose() {
        this.addChangeLister(false);
        this.vctDumpsetListener.removeAllElements();
        this._oValueChange = null;
        this.documentListener = null;
        this.commonActionListen = null;
        this.dumpToActionListen = null;
        return 0;
    }

    public void addDumpSetListener(EmfDumpSetListener l) {
        this.vctDumpsetListener.add(l);
    }

    public void removeDumpSetListener(EmfDumpSetListener l) {
        this.vctDumpsetListener.remove(l);
    }

    protected void fireValueChange() {
        this.bDirty = true;
        int nCount = this.vctDumpsetListener.size();
        for (int i = 0; i < nCount; ++i) {
            EmfDumpSetListener l = (EmfDumpSetListener)this.vctDumpsetListener.get(i);
            l.valueChanged(new ParamModifyEvent((Object)this, true));
        }
    }

    protected void addChangeLister(boolean bAdd) {
        if (bAdd) {
            this.txtDumpInterval.addChangeListener(this._oValueChange);
            this.txtMaxCapacity.addChangeListener(this._oValueChange);
            this.txtPeriodEndTime.addChangeListener(this._oValueChange);
            this.txtDumpRatio.addChangeListener(this._oValueChange);
            this.txtOverflowRatio.addChangeListener(this._oValueChange);
            this.isPeriodComboBox.addItemListener(this.isPeriodListener);
            this.jCboDumpTo.addActionListener(this.dumpToActionListen);
            this.jCboFileFormat.addActionListener(this.commonActionListen);
            this.jTxtDumpPath.getDocument().addDocumentListener(this.documentListener);
        } else {
            this.txtDumpInterval.removeAllChangeListener();
            this.jTxtDumpPath.getDocument().removeDocumentListener(this.documentListener);
            this.jCboFileFormat.removeActionListener(this.commonActionListen);
            this.jCboDumpTo.removeActionListener(this.dumpToActionListen);
            this.isPeriodComboBox.removeItemListener(this.isPeriodListener);
            this.txtOverflowRatio.removeAllChangeListener();
            this.txtDumpRatio.removeAllChangeListener();
            this.txtPeriodEndTime.removeAllChangeListener();
            this.txtMaxCapacity.removeAllChangeListener();
        }
    }

    protected void updateDumpPathState() {
        boolean bSaveToTape = DumpConstants.DUMP_DEST[1].equals(this.jCboDumpTo.getSelectedItem());
        this.jCboFileFormat.setEnabled(!bSaveToTape);
    }

    protected void disablePanel() {
        boolean bEnable = false;
        this.setPeriodState(bEnable);
        this.txtMaxCapacity.setEnabled(bEnable);
        this.txtDumpRatio.setEnabled(bEnable);
        this.txtOverflowRatio.setEnabled(bEnable);
        this.isPeriodComboBox.setEnabled(bEnable);
        this.jCboFileFormat.setEnabled(bEnable);
        this.jCboDumpTo.setEnabled(bEnable);
        this.jTxtDumpPath.setEnabled(bEnable);
    }

    public int actived() {
        if (this.bIsFirst) {
            this.addChangeLister(false);
            this.setDataInfo(this.loadDataInfo());
            this.addChangeLister(true);
        }
        return 0;
    }

    public int deactived() {
        return 0;
    }

    public Container initContainer() {
        this.bDirty = false;
        this.bIsFirst = true;
        return this;
    }

    public boolean isModify() {
        return this.bDirty;
    }

    public int saveCondition() {
        int i = this.saveConditionImpl();
        if (0 == i) {
            this.bDirty = false;
        }
        return i;
    }

    public abstract int saveConditionImpl();

    public abstract DumpSetInfo loadDataInfo();

    private static class MyTitleBorder
    extends CompoundBorder {
        public MyTitleBorder(String strTitle) {
            super(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), strTitle), BorderFactory.createEmptyBorder(4, 4, 4, 4));
        }

        public void setTitle(String strTitle) {
            TitledBorder titleBorder = (TitledBorder)this.insideBorder;
            titleBorder.setTitle(strTitle);
        }
    }
}

