/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.dump.ui;

import com.swimap.external.common.adapter.message.util.CommonUtilities;
import com.swimap.external.common.adapter.message.util.EmfOptionPane;
import com.swimap.external.general.adapter.message.EmfDumpSetListener;
import com.swimap.external.general.adapter.message.EmfDumpSettingInterface;
import com.swimap.external.general.adapter.message.ParamModifyEvent;
import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.dump.control.DumpSetManager;
import com.swimap.imap.general.dump.data.DumpSetType;
import com.swimap.imap.general.dump.ui.TreeDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DumpSetDlg
extends TreeDialog
implements EmfDumpSetListener {
    private EmfDumpSettingInterface currDumpSetPanel = null;

    public DumpSetDlg(Frame owner, boolean modal) {
        super(owner, modal);
        this.setTitle(this.res.getString("DumpSetting"));
    }

    @Override
    protected void initData() {
        LinkedList types = DumpSetManager.getInstance().getAllDumpSettingType();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.res.getString("DumpSetting"));
        DefaultTreeModel model = new DefaultTreeModel(root);
        DumpSetType dumptype2 = null;
        EmfDumpSettingInterface dumpsetPanel = null;
        for (DumpSetType dumptype2 : types) {
            root.add(new DefaultMutableTreeNode(dumptype2));
            dumpsetPanel = dumptype2.getDumpSettingInterface();
            this.rightPane.add((Component)dumpsetPanel.initContainer(), dumptype2.getID());
            dumpsetPanel.addDumpSetListener((EmfDumpSetListener)this);
        }
        this.typeTree.setModel(model);
        try {
            if (root.children().hasMoreElements()) {
                TreePath path = new TreePath(((DefaultMutableTreeNode)root.getFirstChild()).getPath());
                this.typeTree.setSelectionPath(path);
            }
        }
        catch (Exception e) {
            GeneralLogger.error((String)"error while select the first node", (Throwable)e);
        }
    }

    @Override
    protected void removeListener() {
        super.removeListener();
        if (!DumpSetManager.isExit()) {
            LinkedList types = DumpSetManager.getInstance().getAllDumpSettingType();
            DumpSetType dumptype2 = null;
            EmfDumpSettingInterface dumpsetPanel = null;
            for (DumpSetType dumptype2 : types) {
                dumpsetPanel = dumptype2.getDumpSettingInterface();
                dumpsetPanel.removeDumpSetListener((EmfDumpSetListener)this);
            }
        }
    }

    protected void proccessActions(ActionEvent e) {
        int rest;
        String sActionCommand = e.getActionCommand();
        GeneralLogger.trace("Current dump set action command: " + sActionCommand);
        if ("Del_All_File".equals(sActionCommand)) {
            if (this.confirmAction(sActionCommand)) {
                DumpSetManager.getInstance().delDumpFile();
            }
        } else if ("Restore_Default".equals(sActionCommand)) {
            if (this.confirmAction(sActionCommand)) {
                DumpSetManager.getInstance().restoreSetting();
            }
        } else if ("ACTION_CANCEL".equals(sActionCommand)) {
            if (this.applyButton.isEnabled()) {
                int ret = EmfOptionPane.showConfirmDialog((Component)((Object)this), (String)this.res.getString("Dump_Setting_Changed"), (int)1);
                if (0 == ret) {
                    DumpSetManager.getInstance().saveSetting();
                }
                if (2 != ret && -1 != ret) {
                    this.dispose();
                }
            } else {
                this.dispose();
            }
        } else if ("ACTION_OK".equals(sActionCommand)) {
            int rest2 = DumpSetManager.getInstance().saveSetting();
            if (rest2 == 0) {
                this.dispose();
            }
        } else if ("ACTION_APPLY".equals(sActionCommand) && 0 == (rest = DumpSetManager.getInstance().saveSetting())) {
            this.applyButton.setEnabled(false);
        }
    }

    protected JButton[] getButtons() {
        JButton[] buttons = new JButton[]{this.delAllButton, this.defaultButton, this.okButton, this.cancelButton, this.applyButton};
        CommonUtilities.bindDefaultKeyActions((JDialog)((Object)this), (JButton)this.okButton, (JButton)this.cancelButton);
        return buttons;
    }

    @Override
    protected void switchPanel(DefaultMutableTreeNode node) {
        if (node.isLeaf()) {
            DumpSetType type;
            Object userObj;
            if (null != this.currDumpSetPanel) {
                GeneralLogger.debug((String)("deactived:" + this.currDumpSetPanel));
                this.currDumpSetPanel.deactived();
            }
            if ((userObj = node.getUserObject()) instanceof DumpSetType && null != (type = (DumpSetType)userObj)) {
                this.currDumpSetPanel = type.getDumpSettingInterface();
                GeneralLogger.debug((String)("show:" + type.getID()));
                this.cardLayout.show(this.rightPane, type.getID());
                GeneralLogger.debug((String)("actived:" + this.currDumpSetPanel));
                this.currDumpSetPanel.actived();
            }
        }
    }

    public void valueChanged(ParamModifyEvent e) {
        this.applyButton.setEnabled(e.getApplyBtnEnable());
    }
}

