/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.dump.control;

import com.swimap.external.common.adapter.message.util.CommonUtilities;
import com.swimap.external.general.adapter.message.EmfManualDumpPanelInterface;
import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.imap.general.GeneralUtils;
import com.swimap.imap.general.dump.data.ManualDumpLogType;
import com.swimap.iview.commstyle.commini.DescContainer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class ManualDumpManager {
    private static final int PROGRESS_CMD_CODE = 3104;
    protected GeneralResourceManager res = GeneralResourceManager.getInstance();
    private HashMap manualDumpMap = new HashMap();
    private LinkedList listOrder = new LinkedList();
    private static ManualDumpManager _instance = null;
    private static final int DEL_DUMP_OPERATE = 0;
    private static final int RESTORE_OPERATE = 1;

    private ManualDumpManager() {
    }

    public static synchronized ManualDumpManager getInstance() {
        if (_instance == null) {
            _instance = new ManualDumpManager();
        }
        return _instance;
    }

    public void getManualDumpFromXML() {
        DescContainer[] types;
        DescContainer descRoot = CommonUtilities.getConfigElement((String)"conf/general/dumpconfig", (String)"ManualDump:ManualDumpList");
        String className = null;
        String typeID = null;
        String preTypeID = null;
        EmfManualDumpPanelInterface manualDumpPanel = null;
        if (null != descRoot && null != (types = descRoot.getDescContainer())) {
            for (int i = 0; i < types.length; ++i) {
                if (null == types[i]) continue;
                className = types[i].getParasItemValue("ClassName");
                typeID = types[i].getParasItemValue("TypeID");
                preTypeID = types[i].getParasItemValue("PreTypeID");
                if (null == className || null == typeID) continue;
                try {
                    manualDumpPanel = (EmfManualDumpPanelInterface)Class.forName(className).newInstance();
                    if (null != preTypeID) {
                        this.addManualDump(manualDumpPanel, typeID, preTypeID);
                        continue;
                    }
                    this.addManualDump(manualDumpPanel, typeID);
                    continue;
                }
                catch (Exception e) {
                    GeneralLogger.error((String)className, (Throwable)e);
                }
            }
        }
    }

    public int restoreAllSetting() {
        return this.performAction(1);
    }

    public int delAllDumpFile() {
        return this.performAction(0);
    }

    private int performAction(int iOper) {
        int sessionid = GeneralUtils.getSessionID();
        Iterator it = this.manualDumpMap.values().iterator();
        Vector vctErrorDetail = null;
        int iRet = 0;
        Vector vctErrorInfo = new Vector();
        EmfManualDumpPanelInterface panel = null;
        String action = "";
        for (int i = 0; i < this.manualDumpMap.size(); ++i) {
            panel = (EmfManualDumpPanelInterface)it.next();
            try {
                GeneralLogger.debug((String)(iOper + ":" + panel));
                if (0 == iOper) {
                    vctErrorDetail = panel.delAllDumpFile();
                    if (null == vctErrorDetail) continue;
                    action = this.res.getString("Del_Dump_File");
                    String strDefaultStr = panel.getTitle() + ":" + action;
                    Vector vctTemp = GeneralUtils.convertErrorInfo(strDefaultStr, vctErrorDetail);
                    vctErrorInfo.addAll(vctTemp);
                    continue;
                }
                if (1 != iOper || 0 == (iRet = panel.restore())) continue;
                action = this.res.getString("Restore_Default");
                Vector<String> vct = new Vector<String>();
                vct.add(panel.getTitle() + ":" + action);
                vct.add(GeneralUtils.getErrorInfo(iRet));
                vctErrorInfo.add(vct);
                continue;
            }
            catch (Throwable e) {
                GeneralLogger.error((String)(iOper + ":" + panel), (Throwable)e);
            }
        }
        if (sessionid != GeneralUtils.getSessionID()) {
            GeneralLogger.error((String)"Error: Job finished in diff session");
            return -1;
        }
        if (vctErrorInfo.size() > 0) {
            String msg = this.res.getString("Action_Failed", action);
            GeneralUtils.showResult(null, msg, vctErrorInfo);
        } else {
            String msg = null;
            if (0 == iOper) {
                msg = this.res.getString("Del_Dump_File").toLowerCase();
            } else if (1 == iOper) {
                msg = this.res.getString("Restore_Default").toLowerCase();
            }
            msg = this.res.getString("Action_Succeed", msg);
            GeneralUtils.showNotification(msg);
        }
        return vctErrorInfo.size() == 0 ? 0 : -1;
    }

    public boolean addManualDump(EmfManualDumpPanelInterface manualDumpInf, String strDumpType) {
        GeneralLogger.debug((String)(strDumpType + ":" + manualDumpInf));
        boolean rest = false;
        if (this.isValidType(strDumpType) && null != manualDumpInf) {
            this.manualDumpMap.put(strDumpType, manualDumpInf);
            this.listOrder.remove(strDumpType);
            this.listOrder.add(strDumpType);
            rest = true;
        }
        return rest;
    }

    public boolean addManualDump(EmfManualDumpPanelInterface manualDumpInf, String strDumpType, String strPreDumpType) {
        GeneralLogger.debug((String)(strPreDumpType + ":" + strDumpType + ":" + manualDumpInf));
        boolean rest = false;
        if (this.isValidType(strDumpType) && null != manualDumpInf) {
            this.manualDumpMap.put(strDumpType, manualDumpInf);
            this.listOrder.remove(strDumpType);
            if ("FIRST_NODE".equals(strPreDumpType)) {
                this.listOrder.add(0, strDumpType);
            } else {
                int index = this.listOrder.indexOf(strPreDumpType);
                if (index >= 0) {
                    this.listOrder.add(index + 1, strDumpType);
                } else {
                    this.listOrder.add(strDumpType);
                }
            }
            rest = true;
        }
        return rest;
    }

    private boolean isValidType(String typeID) {
        return null != typeID && !"FIRST_NODE".equals(typeID) && !"LAST_NODE".equals(typeID);
    }

    public boolean removeManualDump(String strDumpType) {
        boolean rest = false;
        this.manualDumpMap.remove(strDumpType);
        rest = this.listOrder.remove(strDumpType);
        return rest;
    }

    public LinkedList getAllManualDumpType() {
        LinkedList<ManualDumpLogType> listDumpTypes = new LinkedList<ManualDumpLogType>();
        Iterator it = this.listOrder.iterator();
        String typeID = null;
        EmfManualDumpPanelInterface panel = null;
        while (it.hasNext()) {
            typeID = (String)it.next();
            panel = (EmfManualDumpPanelInterface)this.manualDumpMap.get(typeID);
            listDumpTypes.add(new ManualDumpLogType(typeID, panel));
        }
        return listDumpTypes;
    }

    public void stop() {
        this.manualDumpMap.clear();
        this.listOrder.clear();
        _instance = null;
    }
}

