/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general.dump.control;

import com.swimap.external.common.adapter.message.util.CommonUtilities;
import com.swimap.external.general.adapter.message.EmfDumpSettingInterface;
import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.imap.general.GeneralUtils;
import com.swimap.imap.general.dump.data.DumpSetType;
import com.swimap.iview.commstyle.commini.DescContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class DumpSetManager {
    protected GeneralResourceManager res = GeneralResourceManager.getInstance();
    private HashMap dumpSettingMap = new HashMap();
    private LinkedList listOrder = new LinkedList();
    private static DumpSetManager _instance = null;
    private static final int DEL_DUMP_OPERATE = 0;
    private static final int RESTORE_OPERATE = 1;
    private static final int SAVE_OPERATE = 2;
    private static final int SUCCESS = 0;
    private static boolean isExit = false;

    private DumpSetManager() {
        isExit = false;
        this.getDumpSettingFromXML();
    }

    public static synchronized DumpSetManager getInstance() {
        if (_instance == null) {
            _instance = new DumpSetManager();
        }
        return _instance;
    }

    public int saveSetting() {
        Iterator it = this.dumpSettingMap.values().iterator();
        ArrayList<EmfDumpSettingInterface> changed = new ArrayList<EmfDumpSettingInterface>();
        EmfDumpSettingInterface setting = null;
        while (it.hasNext()) {
            setting = (EmfDumpSettingInterface)it.next();
            if (!setting.isModify()) continue;
            changed.add(setting);
        }
        return this.performAction(changed, 2);
    }

    public int restoreSetting() {
        return this.performAction(1);
    }

    public int delDumpFile() {
        return this.performAction(0);
    }

    private int performAction(Collection panels, int iOper) {
        int sessionID = GeneralUtils.getSessionID();
        Vector vctErrorInfo = new Vector();
        if (panels != null && !panels.isEmpty()) {
            Iterator it = panels.iterator();
            Vector vctErrorDetail = null;
            int iRet = 0;
            String action = "";
            EmfDumpSettingInterface setting = null;
            for (int i = 0; i < panels.size(); ++i) {
                setting = (EmfDumpSettingInterface)it.next();
                try {
                    Vector<String> vct;
                    GeneralLogger.debug((String)(iOper + ":" + setting));
                    if (0 == iOper) {
                        action = this.res.getString("Del_Dump_File");
                        String strDefaultStr = setting.getTitle() + ":" + action;
                        vctErrorDetail = setting.delAllDumpFile();
                        if (null == vctErrorDetail) continue;
                        Vector vctTemp = GeneralUtils.convertErrorInfo(strDefaultStr, vctErrorDetail);
                        vctErrorInfo.addAll(vctTemp);
                        continue;
                    }
                    if (1 == iOper) {
                        action = this.res.getString("Restore_Default");
                        iRet = setting.restore();
                        if (0 == iRet) continue;
                        vct = new Vector<String>();
                        vct.add(setting.getTitle() + ":" + action);
                        vct.add(GeneralUtils.getErrorInfo(iRet));
                        vctErrorInfo.add(vct);
                        continue;
                    }
                    if (2 != iOper) continue;
                    action = this.res.getString("Save_Dump_Setting");
                    iRet = setting.saveCondition();
                    if (0 == iRet) continue;
                    vct = new Vector();
                    vct.add(setting.getTitle() + ":" + action);
                    vct.add(GeneralUtils.getErrorInfo(iRet));
                    vctErrorInfo.add(vct);
                    continue;
                }
                catch (Throwable e) {
                    GeneralLogger.error((String)(iOper + ":" + setting), (Throwable)e);
                }
            }
            if (sessionID != GeneralUtils.getSessionID()) {
                GeneralLogger.error((String)"Error: Job finished in diff session");
                return -1;
            }
            if (vctErrorInfo.size() > 0) {
                String msg = CommonUtilities.displayOperaResult((String)action, (boolean)false);
                GeneralUtils.showResult(null, msg, vctErrorInfo);
            } else {
                String msg = null;
                if (0 == iOper) {
                    msg = this.res.getString("Del_Dump_File").toLowerCase();
                } else if (1 == iOper) {
                    msg = this.res.getString("Restore_Default").toLowerCase();
                }
                if (2 == iOper) {
                    msg = this.res.getString("Save_Dump_Setting").toLowerCase();
                }
                msg = CommonUtilities.displayOperaResult((String)action, (boolean)true);
                GeneralUtils.showNotification(msg);
            }
        }
        return vctErrorInfo.size() == 0 ? 0 : -1;
    }

    private int performAction(int iOper) {
        return this.performAction(this.dumpSettingMap.values(), iOper);
    }

    private void getDumpSettingFromXML() {
        DescContainer[] types;
        DescContainer descRoot = CommonUtilities.getConfigElement((String)"conf/general/dumpconfig", (String)"dumpsetting:dumpSettingList");
        String className = null;
        String typeID = null;
        String preTypeID = null;
        EmfDumpSettingInterface dumpSettingInf = null;
        if (null != descRoot && null != (types = descRoot.getDescContainer())) {
            for (int i = 0; i < types.length; ++i) {
                if (null == types[i]) continue;
                className = types[i].getParasItemValue("ClassName");
                typeID = types[i].getParasItemValue("TypeID");
                preTypeID = types[i].getParasItemValue("PreTypeID");
                if (null == className || null == typeID) continue;
                try {
                    dumpSettingInf = (EmfDumpSettingInterface)Class.forName(className).newInstance();
                    if (null != preTypeID) {
                        this.addDumpSetting(dumpSettingInf, typeID, preTypeID);
                        continue;
                    }
                    this.addDumpSetting(dumpSettingInf, typeID);
                    continue;
                }
                catch (Exception e) {
                    GeneralLogger.error((String)className, (Throwable)e);
                }
            }
        }
    }

    private boolean isValidType(String typeID) {
        return null != typeID && !"FIRST_NODE".equals(typeID) && !"LAST_NODE".equals(typeID);
    }

    public boolean addDumpSetting(EmfDumpSettingInterface dumpSettingInf, String strDumpType) {
        GeneralLogger.debug((String)(strDumpType + ":" + dumpSettingInf));
        boolean rest = false;
        if (this.isValidType(strDumpType) && null != dumpSettingInf) {
            this.dumpSettingMap.put(strDumpType, dumpSettingInf);
            this.listOrder.remove(strDumpType);
            this.listOrder.add(strDumpType);
            rest = true;
        }
        return rest;
    }

    public boolean addDumpSetting(EmfDumpSettingInterface dumpSettingInf, String strDumpType, String strPreDumpType) {
        GeneralLogger.debug((String)(strPreDumpType + ":" + strDumpType + ":" + dumpSettingInf));
        boolean rest = false;
        if (this.isValidType(strDumpType) && null != dumpSettingInf) {
            this.dumpSettingMap.put(strDumpType, dumpSettingInf);
            this.listOrder.remove(strDumpType);
            if ("FIRST_NODE".equals(strPreDumpType)) {
                this.listOrder.add(0, strDumpType);
            } else {
                int index = this.listOrder.indexOf(strPreDumpType);
                if (index >= 0) {
                    this.listOrder.add(index + 1, strDumpType);
                } else {
                    this.listOrder.add(strDumpType);
                }
            }
            rest = true;
        }
        return rest;
    }

    public boolean removeDumpSetting(String strDumpType) {
        boolean rest = false;
        this.dumpSettingMap.remove(strDumpType);
        rest = this.listOrder.remove(strDumpType);
        return rest;
    }

    public LinkedList getAllDumpSettingType() {
        LinkedList<DumpSetType> listDumpTypes = new LinkedList<DumpSetType>();
        Iterator it = this.listOrder.iterator();
        String typeID = null;
        EmfDumpSettingInterface panel = null;
        while (it.hasNext()) {
            typeID = (String)it.next();
            panel = (EmfDumpSettingInterface)this.dumpSettingMap.get(typeID);
            listDumpTypes.add(new DumpSetType(typeID, panel));
        }
        return listDumpTypes;
    }

    public static boolean isExit() {
        return isExit;
    }

    public void stop() {
        isExit = true;
        this.dumpSettingMap.clear();
        this.listOrder.clear();
        _instance = null;
    }
}

