/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general;

import com.swimap.external.common.adapter.message.util.CommonUtilities;
import com.swimap.external.common.adapter.message.util.EmfOptionPane;
import com.swimap.external.eam.client.util.timelocalization.EamGeneralDayLightDate;
import com.swimap.external.sf.general.timelocalization.GeneralDayLightDate;
import com.swimap.external.sm.adapter.message.EmfSecurityInterface;
import com.swimap.imap.general.GeneralLogger;
import com.swimap.imap.general.GeneralModule;
import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.statusbarmanagement.StatusBarManager;
import com.swimap.iview.framework.util.FrameworkGlobalInfo;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruDecoder;
import net.commustru.fstru.FStruct;

public class GeneralUtils {
    protected static GeneralResourceManager res = GeneralResourceManager.getInstance();
    private static EmfSecurityInterface secuInterface = null;

    public static String getResString(String strRes) {
        return res.getString(strRes);
    }

    public static void showNotification(String oMessage) {
        try {
            StatusBarManager oStaBarMgr = (StatusBarManager)GeneralModule.getInstance().getLocalReference("mainstatusbarmanager");
            oStaBarMgr.refreshItem("NotificationMessageItem", GeneralUtils.UpperCaseFirst(oMessage));
        }
        catch (Exception e) {
            GeneralLogger.error((String)oMessage, (Throwable)e);
        }
    }

    public static void showMessageDialog(Component oParent, String szMessage) {
        EmfOptionPane.showMessageDialog((Component)oParent, (String)szMessage);
    }

    public static void showResult(Window wndParent, Vector vctErrInfo) {
        GeneralUtils.showResult(wndParent, res.getString("Oper_Failed"), vctErrInfo);
    }

    public static void showResult(Window wndParent, String strMessage, Vector vctErrInfo) {
        String[][] data = null;
        Iterator iter = vctErrInfo.iterator();
        int nIndex = 0;
        while (iter.hasNext()) {
            Vector vct = (Vector)iter.next();
            if (null == data) {
                data = new String[vctErrInfo.size()][vct.size()];
            }
            for (int i = 0; i < vct.size(); ++i) {
                data[nIndex][i] = vct.get(i).toString();
            }
            ++nIndex;
        }
        CommonUtilities.showErrorDialog((Window)((Dialog)wndParent), (String)strMessage, (Object)data);
    }

    public static String getErrorInfo(long error) {
        String sError = null;
        if (error != 0L) {
            EmfSecurityInterface sec = GeneralUtils.getSecurityInterface();
            sError = sec.getErrorInfo(Long.toString(error));
        } else {
            sError = "";
        }
        return sError;
    }

    public static String UpperCaseFirst(String sentence) {
        String head = sentence.substring(0, 1).toUpperCase();
        String end = sentence.substring(1);
        return head + end;
    }

    public static Vector convertErrorInfo(String strDefaultStr, Vector vctErrorDetail) {
        if (null == vctErrorDetail) {
            return null;
        }
        Vector vctRet = new Vector();
        for (Vector vct : vctErrorDetail) {
            Vector<String> vctInsert = new Vector<String>();
            if (vct.size() < 2) continue;
            if (null == vct.get(0)) {
                vctInsert.add(strDefaultStr);
            } else {
                vctInsert.add((String)vct.get(0));
            }
            Integer intTemp = (Integer)vct.get(1);
            vctInsert.add(GeneralUtils.getErrorInfo(intTemp.intValue()));
            vctRet.add(vctInsert);
        }
        return vctRet;
    }

    public static void centerLocateToScreen(Window childCompo, Component parentCompo) {
        ScreenToolKit.centerLocateToScreen((Component)childCompo);
    }

    public static synchronized boolean receiveNoticeDecode(MSGPacketExt data, FStruct noticeObject) {
        if (data == null) {
            GeneralLogger.trace("Receive a null Msg from the server. FStruct is " + noticeObject.getClass());
            return false;
        }
        byte[] bytes = data.getData();
        if (bytes == null) {
            return false;
        }
        FStruDecoder dec = new FStruDecoder(bytes);
        try {
            noticeObject.deserialize((Decoder)dec);
        }
        catch (Exception e) {
            GeneralLogger.trace("Decode error.", e);
            return false;
        }
        return true;
    }

    public static String getCustomTimeZoneID(int rawOffset) {
        boolean negative = false;
        if (rawOffset < 0) {
            negative = true;
        }
        rawOffset = Math.abs(rawOffset) / 1000;
        int iHour = rawOffset / 3600;
        int iMinute = rawOffset % 3600 / 60;
        String strSign = negative ? "-" : "+";
        String strHour = iHour < 10 ? String.valueOf('0').concat(String.valueOf(iHour)) : String.valueOf(iHour);
        String strMinute = iMinute < 10 ? String.valueOf('0').concat(String.valueOf(iMinute)) : String.valueOf(iMinute);
        return "GMT" + strSign + strHour + ":" + strMinute;
    }

    public static synchronized EmfSecurityInterface getSecurityInterface() {
        if (secuInterface == null) {
            try {
                secuInterface = (EmfSecurityInterface)GeneralModule.getInstance().getLocalReference(FrameworkGlobalInfo.ModuleName.SECURITY_MANAGER_NAME);
            }
            catch (ModuleManagementException e) {
                GeneralLogger.trace((Exception)((Object)e));
            }
        }
        return secuInterface;
    }

    public static int getSessionID() {
        return GeneralUtils.getSecurityInterface().getSessionID();
    }

    public static String buildFileName(String info) {
        Calendar oCalendar = Calendar.getInstance();
        TimeDateFormatUtil.switchLocalCalendar((Calendar)oCalendar);
        StringBuffer sbTime = new StringBuffer();
        int iYear = oCalendar.get(1);
        sbTime.append(iYear).append("_");
        int iMonth = oCalendar.get(2) + 1;
        if (iMonth < 10) {
            sbTime.append("0").append(iMonth).append("_");
        } else {
            sbTime.append(iMonth).append("_");
        }
        int iDay = oCalendar.get(5);
        if (iDay < 10) {
            sbTime.append("0").append(iDay).append("_");
        } else {
            sbTime.append(iDay).append("_");
        }
        int iHour = oCalendar.get(11);
        if (iHour < 10) {
            sbTime.append("0").append(iHour).append("_");
        } else {
            sbTime.append(iHour).append("_");
        }
        int iMinite = oCalendar.get(12);
        if (iMinite < 10) {
            sbTime.append("0").append(iMinite).append("_");
        } else {
            sbTime.append(iMinite).append("_");
        }
        int iSecond = oCalendar.get(13);
        if (iSecond < 10) {
            sbTime.append("0").append(iSecond);
        } else {
            sbTime.append(iSecond);
        }
        return new StringBuffer(info + "_").append(sbTime.toString()).toString();
    }

    public static GeneralDayLightDate convertEam2GeneralDayLightDate(EamGeneralDayLightDate eamDayLightDate) {
        if (eamDayLightDate == null) {
            return null;
        }
        GeneralDayLightDate generalDate = new GeneralDayLightDate(eamDayLightDate.getG_iDayLightType(), eamDayLightDate.getG_iMonth(), eamDayLightDate.getG_iDay(), eamDayLightDate.getG_iWeekOfMonth(), eamDayLightDate.getG_iDayOfWeek(), eamDayLightDate.getG_iHour(), eamDayLightDate.getG_iMinute(), eamDayLightDate.getG_iSecond());
        return generalDate;
    }
}

