/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general;

import com.swimap.imap.general.GeneralLogger;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import java.util.Hashtable;

public class GeneralTimeModeHandler {
    private static final String TIMEMODE_XML_CFG_FILE = "conf/general/timemodeConfig";
    private static final String[] PARA_NAMES = new String[]{"ISSHOW", "TYPE"};
    private static GeneralTimeModeHandler _instance = null;
    private static CommStyleInfo commStyleInfo = null;
    private Hashtable m_htParam = new Hashtable();

    private GeneralTimeModeHandler() {
    }

    public static synchronized GeneralTimeModeHandler getInstance() {
        if (_instance == null) {
            _instance = new GeneralTimeModeHandler();
        }
        return _instance;
    }

    public void initTimeMode() {
        boolean m_bShowTab = false;
        int m_iLocalType = 0;
        try {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(TIMEMODE_XML_CFG_FILE);
            AreaDescContainer areaMain = commStyleInfo.getAreaDescContainer("TIME_MODE");
            DescContainer descObject = areaMain.getDescContainer("SHOW_TIME_MODE");
            String strPara = descObject.getParasItemValue("ISSHOW");
            m_bShowTab = strPara.equalsIgnoreCase("true");
            descObject = areaMain.getDescContainer("TIME_LOCALIZATION_MODE");
            strPara = descObject.getParasItemValue("TYPE");
            int iPara = Integer.parseInt(strPara);
            m_iLocalType = iPara == 1 ? iPara : m_iLocalType;
        }
        catch (Exception e) {
            GeneralLogger.debug((String)"Read timemodeConfig.xml error! ", (Throwable)e);
        }
        this.m_htParam.put(PARA_NAMES[0], m_bShowTab);
        this.m_htParam.put(PARA_NAMES[1], new Integer(m_iLocalType));
    }

    public boolean saveProperty(int iType) {
        try {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(TIMEMODE_XML_CFG_FILE);
            AreaDescContainer areaMain = commStyleInfo.getAreaDescContainer("TIME_MODE");
            DescContainer descObject = areaMain.getDescContainer("TIME_LOCALIZATION_MODE");
            descObject.setParasItem("TYPE", String.valueOf(iType));
            commStyleInfo.writeBackPersonal();
        }
        catch (Exception e) {
            GeneralLogger.debug((String)"Write timemodeConfig.xml error! ", (Throwable)e);
            return false;
        }
        this.m_htParam.put(PARA_NAMES[1], new Integer(iType));
        return true;
    }

    public boolean isShowTimeModeTab() {
        Boolean bTmp = (Boolean)this.m_htParam.get(PARA_NAMES[0]);
        return bTmp == null ? false : bTmp;
    }

    public int getTimeLocalizationMode() {
        Integer iTmp = (Integer)this.m_htParam.get(PARA_NAMES[1]);
        return iTmp == null ? 0 : iTmp;
    }

    public boolean isClientLocalTimeUsed() {
        return this.getTimeLocalizationMode() == 0;
    }

    public void stop() {
        if (this.m_htParam != null) {
            this.m_htParam.clear();
            this.m_htParam = null;
        }
        commStyleInfo = null;
        _instance = null;
    }
}

