/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general;

import com.swimap.external.common.adapter.message.util.CommonLogger;
import com.swimap.imap.common.commoninterface.general.ISoundConfig;
import com.swimap.imap.common.commoninterface.general.SoundHandler;
import com.swimap.imap.general.setting.EmfSoundConfig;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class GeneralSoundHandler {
    private static GeneralSoundHandler instance = null;
    private List defSoundList = null;
    private List curSoundList = null;
    private Map curSoundMap = null;
    private Map defSoundMap = null;

    public static GeneralSoundHandler getInstance() {
        if (instance == null) {
            instance = new GeneralSoundHandler();
        }
        return instance;
    }

    public void initSound() {
        this.defSoundList = new ArrayList();
        this.curSoundList = new ArrayList();
        this.defSoundMap = new HashMap();
        this.curSoundMap = new HashMap();
        String descName = null;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/general/soundConfig");
        if (commStyleInfo == null) {
            return;
        }
        DescContainer[] devDescs = commStyleInfo.getAreaDescContainer(0).getDescContainer();
        for (int i = 0; i < devDescs.length; ++i) {
            descName = devDescs[i].getDescName();
            if (descName.compareTo("Current_Sound_Config") == 0) {
                this.readCurFaultStatus(devDescs[i]);
                continue;
            }
            if (descName.compareTo("Default_Sound_Config") != 0) continue;
            this.readDefFaultStatus(devDescs[i]);
        }
    }

    private void readCurFaultStatus(DescContainer desc) {
        if (desc == null) {
            return;
        }
        DescContainer[] propertyDescs = desc.getDescContainer();
        if (propertyDescs == null || propertyDescs.length <= 0) {
            return;
        }
        for (int i = 0; i < propertyDescs.length; ++i) {
            String sKey = propertyDescs[i].getDescName();
            String stFlag = propertyDescs[i].getParasItemValue("flag");
            String stName = propertyDescs[i].getParasItemValue("name");
            String stTime = propertyDescs[i].getParasItemValue("time");
            String stDesc = propertyDescs[i].getParasItemValue("desc");
            EmfSoundConfig sound = new EmfSoundConfig();
            sound.setKey(sKey);
            boolean isPlaySound = Integer.parseInt(stFlag) == 1;
            sound.setIsSoundable(isPlaySound);
            sound.setSoundFileName(stName);
            sound.setTime(Integer.parseInt(stTime));
            sound.setSoundDesc(stDesc);
            this.curSoundMap.put(sKey, sound);
            this.curSoundList.add(sound);
        }
    }

    private void readDefFaultStatus(DescContainer desc) {
        if (desc == null) {
            return;
        }
        DescContainer[] propertyDescs = desc.getDescContainer();
        if (propertyDescs == null || propertyDescs.length <= 0) {
            return;
        }
        for (int i = 0; i < propertyDescs.length; ++i) {
            String sKey = propertyDescs[i].getDescName();
            String stFlag = propertyDescs[i].getParasItemValue("flag");
            String stName = propertyDescs[i].getParasItemValue("name");
            String stTime = propertyDescs[i].getParasItemValue("time");
            String stDesc = propertyDescs[i].getParasItemValue("desc");
            EmfSoundConfig sound = new EmfSoundConfig();
            sound.setKey(sKey);
            boolean isPlaySound = Integer.parseInt(stFlag) == 1;
            sound.setIsSoundable(isPlaySound);
            StringBuffer absPath = new StringBuffer(System.getProperty("user.dir")).append(File.separator).append(ResourceMng.getInstance().getResourceDir());
            if (stName != null && (stName.startsWith("/") || stName.startsWith("\\"))) {
                stName = stName.substring(1);
            }
            absPath.append(stName);
            String temp = absPath.toString();
            temp = temp.replace('/', File.separatorChar);
            temp = temp.replace('\\', File.separatorChar);
            sound.setSoundFileName(temp);
            sound.setTime(Integer.parseInt(stTime));
            sound.setSoundDesc(stDesc);
            this.defSoundMap.put(sKey, sound);
            this.defSoundList.add(sound);
        }
    }

    public ISoundConfig getSound(String key) {
        if (this.curSoundList == null || this.curSoundList.size() <= 0) {
            return null;
        }
        ISoundConfig sound2 = null;
        for (ISoundConfig sound2 : this.curSoundList) {
            if (!key.equals(sound2.getKey())) continue;
            return sound2;
        }
        return null;
    }

    public ISoundConfig getDefSound(String key) {
        return (ISoundConfig)this.defSoundMap.get(key);
    }

    public void registerExtensionSoundHandler(SoundHandler handler) {
        List extentSoundlist = handler.getExtensionSoundConfig();
        List defaultSoundList = handler.getExtensionDefaultSoundConfig();
        this.updateSoundConfig(this.curSoundList, extentSoundlist, this.curSoundMap);
        this.updateSoundConfig(this.defSoundList, defaultSoundList, this.defSoundMap);
    }

    private void updateSoundConfig(List oldSoundList, List extendSoundList, Map soundMap) {
        if (oldSoundList == null || oldSoundList.size() <= 0) {
            return;
        }
        if (extendSoundList == null || extendSoundList.size() <= 0) {
            return;
        }
        if (soundMap == null || soundMap.size() <= 0) {
            return;
        }
        Object obj = null;
        ISoundConfig TEPSound = null;
        EmfSoundConfig soundConfig = null;
        for (int i = 0; i < extendSoundList.size(); ++i) {
            obj = extendSoundList.get(i);
            if (!(obj instanceof ISoundConfig)) continue;
            TEPSound = obj;
            if (TEPSound == null) {
                CommonLogger.debug((String)"The value of TEPSound is null!!!");
                return;
            }
            soundConfig = new EmfSoundConfig();
            soundConfig.setKey(TEPSound.getKey());
            soundConfig.setSoundDesc(TEPSound.getSoundDesc());
            soundConfig.setSoundFileName(TEPSound.getSoundFileName());
            soundConfig.setIsSoundable(TEPSound.isPlaySound());
            soundConfig.setTime(TEPSound.getTime());
            if (soundMap.containsKey(soundConfig.getKey())) {
                CommonLogger.debug((String)("Sound key is repeated: the sound key is" + soundConfig.getKey()));
                continue;
            }
            oldSoundList.add(soundConfig);
            soundMap.put(soundConfig.getKey(), soundConfig);
        }
    }

    public boolean saveSoundConfig(List soundCfg) {
        if (null == soundCfg) {
            return false;
        }
        int size = soundCfg.size();
        if (size <= 0) {
            return false;
        }
        CommStyleInfo commStyleInfo = null;
        try {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/general/soundConfig");
            DescContainer currentDesc = commStyleInfo.getAreaDescContainer(0).getDescContainer("Current_Sound_Config");
            EmfSoundConfig soundConfig = null;
            if (currentDesc == null) {
                return false;
            }
            DescContainer[] propertyDescs = currentDesc.getDescContainer();
            if (propertyDescs == null || propertyDescs.length <= 0) {
                return false;
            }
            for (int i = 0; i < propertyDescs.length; ++i) {
                soundConfig = (EmfSoundConfig)soundCfg.get(i);
                if (soundConfig == null) continue;
                DescContainer oDesc = currentDesc.getDescContainer(i);
                if (soundConfig.isPlaySound()) {
                    oDesc.setParasItem("flag", Integer.toString(1));
                } else {
                    oDesc.setParasItem("flag", Integer.toString(0));
                }
                oDesc.setParasItem("name", soundConfig.getSoundFileName());
                oDesc.setParasItem("time", Integer.toString(soundConfig.getTime()));
            }
            commStyleInfo.writeBackPersonal();
        }
        catch (Exception ex) {
            CommonLogger.debug((String)ex.toString());
            return false;
        }
        return true;
    }

    public List getCurSoundCfg() {
        return this.curSoundList;
    }

    public void setCurSoundCfg(List soundCfg) {
        this.curSoundList = soundCfg;
    }

    public void updateSoundMap(Vector sound) {
        if (sound == null || sound.size() <= 0) {
            return;
        }
        if (this.curSoundMap == null || this.curSoundMap.size() <= 0) {
            return;
        }
        EmfSoundConfig soundCfg = null;
        for (int i = 0; i < sound.size(); ++i) {
            soundCfg = (EmfSoundConfig)sound.get(i);
            this.curSoundMap.put(soundCfg.getKey(), soundCfg);
        }
    }

    public List getDefSoundCfg() {
        return this.defSoundList;
    }

    public void stop() {
        this.defSoundList = null;
        this.curSoundList = null;
        this.defSoundMap = null;
        this.curSoundMap = null;
        instance = null;
    }
}

