/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general;

import com.swimap.imap.general.GeneralModule;
import com.swimap.iview.util.log.IviewLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class GeneralResourceManager {
    private static GeneralResourceManager _instance;
    private static ResourceBundle res;
    private static final IviewLogger logger;
    private static String m_oIconPath;

    private GeneralResourceManager() {
    }

    public static GeneralResourceManager getInstance() {
        if (_instance == null) {
            _instance = new GeneralResourceManager();
        }
        return _instance;
    }

    public String getString(String key) {
        return res.getString(key);
    }

    public String getString(String szkey, Object ... params) {
        StringBuffer result = null;
        try {
            result = new StringBuffer(MessageFormat.format(this.getString(szkey), params));
        }
        catch (Exception e) {
            logger.trace((Object)e);
            return szkey;
        }
        return result.toString();
    }

    public static ImageIcon getImageIcon(String szFile) {
        try {
            if (szFile == null || szFile.length() == 0) {
                return null;
            }
            String szPath = m_oIconPath + szFile;
            ImageIcon oIcon = (ImageIcon)GeneralModule.getPlugin().getResource().getIcon(szPath);
            return oIcon;
        }
        catch (Exception e) {
            logger.trace((Object)e);
            return null;
        }
    }

    static {
        res = GeneralModule.getPlugin().getResource().getResourceBundleFromPropertyFile("general/generalresource");
        logger = IviewLogger.getLogger(GeneralResourceManager.class, (String)"TM");
        m_oIconPath = "general/image/";
    }
}

