/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general;

import com.swimap.external.general.adapter.message.EmfDumpSettingInterface;
import com.swimap.external.general.adapter.message.EmfManualDumpPanelInterface;
import com.swimap.external.general.adapter.message.GeneralInterface;
import com.swimap.imap.common.commoninterface.general.AudioPlayerInterface;
import com.swimap.imap.common.commoninterface.general.ISoundConfig;
import com.swimap.imap.common.commoninterface.general.SoundHandler;
import com.swimap.imap.common.commoninterface.general.sound.IPlayerManager;
import com.swimap.imap.general.GeneralColorHandler;
import com.swimap.imap.general.GeneralResourceManager;
import com.swimap.imap.general.GeneralSeverityHandler;
import com.swimap.imap.general.GeneralSoundHandler;
import com.swimap.imap.general.GeneralTimeModeHandler;
import com.swimap.imap.general.dump.control.DumpSetManager;
import com.swimap.imap.general.dump.control.ManualDumpManager;
import com.swimap.imap.general.dump.ui.DumpSetDlg;
import com.swimap.imap.general.dump.ui.ManualDumpDlg;
import com.swimap.imap.general.progress.ProgressManager;
import com.swimap.imap.general.sound.PlayerManager;
import com.swimap.imap.general.util.AuditionPlayer;
import com.swimap.iview.commstyle.commandmng.ICommandProcessor;
import com.swimap.iview.communicate.CommManageService;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GeneralModule
extends BaseModule
implements GeneralInterface,
ICommandProcessor {
    private static final IviewLogger logger = IviewLogger.getLogger(GeneralModule.class, (String)"TM");
    private static GeneralModule _instance = null;
    private MenuManager oMenuManager = null;
    private SystemSettingsManager settingManager = null;
    public CommManageService m_oCommMgr = null;
    private JMenu fileMenu = null;
    private ManualDumpDlg manualDumpDlg = null;
    private PopupMenuListener m_popupListener = null;
    private int timemodeSettingID = -1;
    private PlayerManager playerManager = null;
    private static final String PLUGIN_ID = "com.swimap.adapter.message.general";
    private static final String PLUGIN_EXPORT_NAME = "EmfProductResourceIdCustomize";

    public GeneralModule(ModuleManager moduleManager) {
        super(moduleManager);
        _instance = this;
    }

    public static GeneralModule getInstance() {
        return _instance;
    }

    public void initialize() {
        try {
            this.m_oCommMgr = (CommManageService)this.getLocalReference("communicateservice");
            this.settingManager = (SystemSettingsManager)this.getLocalReference("mainsystemsettingmanager");
            GeneralColorHandler.getInstance().initColors();
            GeneralSoundHandler.getInstance().initSound();
            if (GeneralTimeModeHandler.getInstance().isShowTimeModeTab()) {
                this.timemodeSettingID = this.settingManager.addClientModuleSettings("com.swimap.imap.general.setting.EmfTimeModeSetting", "com.swimap.imap.general.setting.EmfTimeModeSetting");
            }
            this.oMenuManager = (MenuManager)this.getLocalReference("mainmenumanager");
            this.playerManager = new PlayerManager();
            ManualDumpManager.getInstance().getManualDumpFromXML();
        }
        catch (Exception ex) {
            logger.trace((Object)ex);
        }
        try {
            this.fileMenu = this.oMenuManager.getMenu("mainMenu", "FileMenu");
            this.m_popupListener = new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    InternalFrame internalFrame = (InternalFrame)FrameworkUtilities.getWindowManager().getActiveWindow();
                    boolean bPrintableActiveWindow = false;
                    boolean bPreviewable = false;
                    if (internalFrame != null) {
                        bPrintableActiveWindow = internalFrame.isPrintable();
                        bPreviewable = internalFrame.isPreviewable();
                    }
                    GeneralModule.this.setMenuState("mainMenu", "FileMenu", "Print", bPrintableActiveWindow);
                    GeneralModule.this.setMenuState("mainMenu", "FileMenu", "Print_Preview", bPreviewable);
                    GeneralModule.this.setMenuState("mainMenu", "FileMenu", "Page_Setup", bPrintableActiveWindow || bPreviewable);
                }
            };
            this.fileMenu.getPopupMenu().addPopupMenuListener(this.m_popupListener);
        }
        catch (Exception e) {
            logger.trace((Object)e);
        }
    }

    public void setMenuState(String mainMenuName, String menuName, String subMenuItem, boolean bEnable) {
        Component menuItem = this.oMenuManager.getMenuItem(mainMenuName, menuName, subMenuItem);
        if (menuItem != null) {
            menuItem.setEnabled(bEnable);
        }
    }

    public void stop() {
        ManualDumpManager.getInstance().stop();
        DumpSetManager.getInstance().stop();
        GeneralSoundHandler.getInstance().stop();
        GeneralColorHandler.getInstance().stop();
        GeneralTimeModeHandler.getInstance().stop();
        ProgressManager.getInstance().stop();
        this.getAuditionPlayer().stopSound();
        this.settingManager.removeSetting(this.timemodeSettingID);
        if (this.playerManager != null) {
            this.playerManager.exit();
        }
        if (this.fileMenu != null) {
            this.fileMenu.getPopupMenu().removePopupMenuListener(this.m_popupListener);
        }
        _instance = null;
        this.settingManager = null;
        this.oMenuManager = null;
        this.fileMenu = null;
        this.m_popupListener = null;
    }

    public Color getColor(String key) {
        return GeneralColorHandler.getInstance().getColor(key);
    }

    public Map getAllColor() {
        return GeneralColorHandler.getInstance().getAllColor();
    }

    public ISoundConfig getSound(String key) {
        return GeneralSoundHandler.getInstance().getSound(key);
    }

    public void registerExtensionSoundHandler(SoundHandler handler) {
        GeneralSoundHandler.getInstance().registerExtensionSoundHandler(handler);
    }

    public void openDumpSetDlg() {
        DumpSetDlg dumpSetDlg = new DumpSetDlg(FrameworkUtilities.getMainFrame(), true);
        dumpSetDlg.setSize(540, 450);
        dumpSetDlg.setResizable(false);
        ScreenToolKit.centerLocateToScreen((Component)((Object)dumpSetDlg));
        dumpSetDlg.setVisible(true);
    }

    public boolean registerDumpSetting(EmfDumpSettingInterface dumpSettingInf, String strDumpType, String strPreDumpType) {
        return DumpSetManager.getInstance().addDumpSetting(dumpSettingInf, strDumpType, strPreDumpType);
    }

    public boolean unregisterDumpSetting(String strDumpType) {
        return DumpSetManager.getInstance().removeDumpSetting(strDumpType);
    }

    public boolean registerDumpSetting(EmfDumpSettingInterface dumpSettingInf, String strDumpType) {
        return DumpSetManager.getInstance().addDumpSetting(dumpSettingInf, strDumpType);
    }

    public void openManualDumpDlg() {
        if (this.manualDumpDlg == null) {
            this.manualDumpDlg = new ManualDumpDlg(FrameworkUtilities.getMainFrame(), true);
            this.manualDumpDlg.setSize(510, 440);
            this.manualDumpDlg.setResizable(false);
        }
        this.manualDumpDlg.setVisible(true);
    }

    public boolean registerManualDumpPanel(EmfManualDumpPanelInterface manualDumpPanelInf, String strDumpType) {
        return ManualDumpManager.getInstance().addManualDump(manualDumpPanelInf, strDumpType);
    }

    public boolean registerManualDumpPanel(EmfManualDumpPanelInterface manualDumpPanelInf, String strDumpType, String strPreDumpType) {
        return ManualDumpManager.getInstance().addManualDump(manualDumpPanelInf, strDumpType, strPreDumpType);
    }

    public boolean unregisterManualDumpPanel(String strDumpType) {
        return ManualDumpManager.getInstance().removeManualDump(strDumpType);
    }

    public void setShowSpecifyColor(String colorKey, boolean supportFlag) {
        GeneralSeverityHandler.getInstance().setShowSpecifyColor(colorKey, supportFlag);
    }

    public AudioPlayerInterface getAuditionPlayer() {
        return AuditionPlayer.getInstance();
    }

    public IPlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public static Plugin getPlugin() {
        return PluginManager.getInstance().getPlugin(PLUGIN_ID);
    }

    public String getString(String key) {
        return GeneralResourceManager.getInstance().getString(key);
    }
}

