/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.general;

import com.swimap.external.common.adapter.message.util.CommonLogger;
import com.swimap.imap.general.GeneralCommDateCovert;
import com.swimap.imap.general.GeneralSeverityHandler;
import com.swimap.imap.general.setting.EmfColorConfig;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARAS;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneralColorHandler
implements PropertyChangeListener {
    private static GeneralColorHandler instance = null;
    private List currentColors = null;
    private List defaultColors = null;

    private GeneralColorHandler() {
        GeneralSeverityHandler.getInstance().addChangedDate(this);
    }

    public static GeneralColorHandler getInstance() {
        if (instance == null) {
            instance = new GeneralColorHandler();
        }
        return instance;
    }

    public void initColors() {
        this.currentColors = new ArrayList();
        this.defaultColors = new ArrayList();
        String descName = null;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/general/colorConfig");
        if (commStyleInfo == null) {
            return;
        }
        DescContainer[] devDescs = commStyleInfo.getAreaDescContainer(0).getDescContainer();
        for (int i = 0; i < devDescs.length; ++i) {
            descName = devDescs[i].getDescName();
            if (descName.compareTo("Current_Color_Config") == 0) {
                this.readCurFaultStatus(devDescs[i]);
                continue;
            }
            if (descName.compareTo("Default_Color_Config") != 0) continue;
            this.readDefFaultStatus(devDescs[i]);
        }
    }

    private void readCurFaultStatus(DescContainer desc) {
        String paraName = null;
        String paraValue = null;
        Color color = null;
        if (desc == null) {
            return;
        }
        PARAS paras = desc.getPARAS();
        int count = paras.getPARACount();
        EmfColorConfig colorCfg = null;
        for (int i = 0; i < count; ++i) {
            paraName = paras.getPARA(i).getName();
            paraValue = paras.getPARA(i).getValue();
            color = this.stringToColor(paraValue);
            colorCfg = new EmfColorConfig();
            colorCfg.setColor(color);
            colorCfg.setKey(paraName);
            this.currentColors.add(colorCfg);
        }
    }

    private void readDefFaultStatus(DescContainer desc) {
        String paraName = null;
        String paraValue = null;
        Color color = null;
        if (desc == null) {
            return;
        }
        PARAS paras = desc.getPARAS();
        int count = paras.getPARACount();
        EmfColorConfig colorCfg = null;
        for (int i = 0; i < count; ++i) {
            paraName = paras.getPARA(i).getName();
            paraValue = paras.getPARA(i).getValue();
            color = this.stringToColor(paraValue);
            colorCfg = new EmfColorConfig();
            colorCfg.setKey(paraName);
            colorCfg.setColor(color);
            this.defaultColors.add(colorCfg);
        }
    }

    private Color stringToColor(String color) {
        if (color == null) {
            return null;
        }
        int firstIndex = color.indexOf(".");
        int lastIndex = color.lastIndexOf(".");
        if (firstIndex == -1 || lastIndex == -1) {
            return null;
        }
        if (firstIndex == lastIndex) {
            return null;
        }
        try {
            int r = Integer.parseInt(color.substring(0, firstIndex));
            int g = Integer.parseInt(color.substring(firstIndex + 1, lastIndex));
            int b = Integer.parseInt(color.substring(lastIndex + 1, color.length()));
            return new Color(r, g, b);
        }
        catch (Exception ex) {
            CommonLogger.debug((String)ex.toString());
            return null;
        }
    }

    public boolean saveColorConfig(List updateColor) {
        if (updateColor == null) {
            return false;
        }
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/general/colorConfig");
            DescContainer currentDesc = commStyleInfo.getAreaDescContainer(0).getDescContainer("Current_Color_Config");
            PARAS paras = currentDesc.getPARAS();
            Color color = null;
            String colorToString = null;
            EmfColorConfig colorConfig = null;
            String name = null;
            int count = paras.getPARACount();
            if (updateColor.size() == count) {
                for (int i = 0; i < count; ++i) {
                    colorConfig = (EmfColorConfig)updateColor.get(i);
                    if (colorConfig == null) continue;
                    name = paras.getPARA(i).getName();
                    if (!colorConfig.getKey().equals(name)) continue;
                    color = colorConfig.getColor();
                    if (color == null) {
                        CommonLogger.debug((String)"Method GeneralColorHandler.saveColorConfig() exception: The color is null!");
                        continue;
                    }
                    colorToString = GeneralCommDateCovert.colorToString(color);
                    paras.getPARA(i).setValue(colorToString);
                }
            } else if (updateColor.size() < count) {
                for (int i = 0; i < updateColor.size(); ++i) {
                    colorConfig = (EmfColorConfig)updateColor.get(i);
                    if (colorConfig == null) continue;
                    if (i >= 4) {
                        name = paras.getPARA(i + 1).getName();
                        if (!colorConfig.getKey().equals(name)) continue;
                        color = colorConfig.getColor();
                        if (color == null) {
                            CommonLogger.debug((String)"Method GeneralColorHandler.saveColorConfig() exception: The color is null!");
                            continue;
                        }
                        colorToString = GeneralCommDateCovert.colorToString(color);
                        paras.getPARA(i + 1).setValue(colorToString);
                        continue;
                    }
                    name = paras.getPARA(i).getName();
                    if (!colorConfig.getKey().equals(name)) continue;
                    color = colorConfig.getColor();
                    if (color == null) {
                        CommonLogger.debug((String)"Method GeneralColorHandler.saveColorConfig() exception: The color is null!");
                        continue;
                    }
                    colorToString = GeneralCommDateCovert.colorToString(color);
                    paras.getPARA(i).setValue(colorToString);
                }
            }
            commStyleInfo.writeBackPersonal();
            return true;
        }
        catch (Exception ex) {
            CommonLogger.debug((String)ex.toString());
            return false;
        }
    }

    public Color getColor(String key) {
        if (this.currentColors != null) {
            EmfColorConfig colorConfig = null;
            for (int i = 0; i < this.currentColors.size(); ++i) {
                colorConfig = (EmfColorConfig)this.currentColors.get(i);
                if (colorConfig == null || !colorConfig.getKey().equals(key)) continue;
                return colorConfig.getColor();
            }
        }
        return null;
    }

    public Map getAllColor() {
        HashMap<String, Color> oColor = new HashMap<String, Color>();
        if (this.currentColors == null || this.currentColors.size() <= 0) {
            return null;
        }
        EmfColorConfig colorConfig = null;
        for (int i = 0; i < this.currentColors.size(); ++i) {
            colorConfig = (EmfColorConfig)this.currentColors.get(i);
            if (colorConfig == null) continue;
            oColor.put(colorConfig.getKey(), colorConfig.getColor());
        }
        return oColor;
    }

    public void setCurrentColor(List colorList) {
        this.currentColors = colorList;
    }

    public List getCurrentColor() {
        return this.currentColors;
    }

    public Color getAlarmColorIndex(byte byColorLevel) {
        Color color = null;
        try {
            if (byColorLevel < 1 || byColorLevel > 8) {
                byColorLevel = 1;
            }
            EmfColorConfig colorCfg = (EmfColorConfig)this.currentColors.get(byColorLevel - 1);
            color = colorCfg.getColor();
            return color;
        }
        catch (Exception ex) {
            CommonLogger.debug((String)ex.toString());
            return color;
        }
    }

    public List getDefaultColor() {
        return this.defaultColors;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String colorKey = evt.getPropertyName();
        boolean flag = Boolean.getBoolean(evt.getNewValue().toString());
        if (this.currentColors == null || this.currentColors.size() <= 0) {
            return;
        }
        EmfColorConfig curColorCfg = null;
        for (int i = 0; i < this.currentColors.size(); ++i) {
            curColorCfg = (EmfColorConfig)this.currentColors.get(i);
            if (curColorCfg == null || !curColorCfg.getKey().equals(colorKey)) continue;
            curColorCfg.setShow(flag);
        }
        if (this.defaultColors == null || this.defaultColors.size() <= 0) {
            return;
        }
        EmfColorConfig defColorCfg = null;
        for (int i = 0; i < this.defaultColors.size(); ++i) {
            defColorCfg = (EmfColorConfig)this.defaultColors.get(i);
            if (defColorCfg == null || !defColorCfg.getKey().equals(colorKey)) continue;
            defColorCfg.setShow(flag);
        }
    }

    public void stop() {
        this.currentColors = null;
        this.defaultColors = null;
        instance = null;
    }
}

