/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import com.swimap.imap.common.asn1.topo.AsnTopoLinkTypeInt;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnTopoLinkType
implements FStruct {
    public BigInteger iLinkTypeID;
    public byte[] strName;
    public BigInteger iClass;
    public AsnTopoLinkTypeInt iUserCreatable = new AsnTopoLinkTypeInt();
    public byte[] strsymbol;
    public BigInteger iAppProcID;
    public BigInteger iIsMulti;

    public AsnTopoLinkType() {
    }

    public AsnTopoLinkType(AsnTopoLinkType arg) {
        this.iLinkTypeID = arg.iLinkTypeID;
        this.strName = new byte[arg.strName.length];
        System.arraycopy(arg.strName, 0, this.strName, 0, arg.strName.length);
        this.iClass = arg.iClass;
        this.iUserCreatable = new AsnTopoLinkTypeInt(arg.iUserCreatable);
        this.strsymbol = new byte[arg.strsymbol.length];
        System.arraycopy(arg.strsymbol, 0, this.strsymbol, 0, arg.strsymbol.length);
        this.iAppProcID = arg.iAppProcID;
        this.iIsMulti = arg.iIsMulti;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iLinkTypeID);
        enc.serializeOctetString(this.strName);
        enc.serializeInteger(this.iClass);
        this.iUserCreatable.serialize(enc);
        enc.serializeOctetString(this.strsymbol);
        enc.serializeInteger(this.iAppProcID);
        enc.serializeInteger(this.iIsMulti);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iLinkTypeID = dec.deserializeInteger();
        this.strName = dec.deserializeOctetString();
        this.iClass = dec.deserializeInteger();
        this.iUserCreatable.deserialize(dec);
        this.strsymbol = dec.deserializeOctetString();
        this.iAppProcID = dec.deserializeInteger();
        this.iIsMulti = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iLinkTypeID = ");
        os.print(this.iLinkTypeID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strName = ");
        os.print(FStruFormat.convertToString((byte[])this.strName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iClass = ");
        os.print(this.iClass.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iUserCreatable = ");
        this.iUserCreatable.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strsymbol = ");
        os.print(FStruFormat.convertToString((byte[])this.strsymbol));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iAppProcID = ");
        os.print(this.iAppProcID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iIsMulti = ");
        os.print(this.iIsMulti.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

