/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnTopoIfLegendItem
implements FStruct {
    public byte[] parent;
    public byte[] legendid;
    public byte[] strSymbol;
    public byte[] strComment;
    public BigInteger iIsLeaf;

    public AsnTopoIfLegendItem() {
    }

    public AsnTopoIfLegendItem(AsnTopoIfLegendItem arg) {
        this.parent = new byte[arg.parent.length];
        System.arraycopy(arg.parent, 0, this.parent, 0, arg.parent.length);
        this.legendid = new byte[arg.legendid.length];
        System.arraycopy(arg.legendid, 0, this.legendid, 0, arg.legendid.length);
        this.strSymbol = new byte[arg.strSymbol.length];
        System.arraycopy(arg.strSymbol, 0, this.strSymbol, 0, arg.strSymbol.length);
        this.strComment = new byte[arg.strComment.length];
        System.arraycopy(arg.strComment, 0, this.strComment, 0, arg.strComment.length);
        this.iIsLeaf = arg.iIsLeaf;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.parent);
        enc.serializeOctetString(this.legendid);
        enc.serializeOctetString(this.strSymbol);
        enc.serializeOctetString(this.strComment);
        enc.serializeInteger(this.iIsLeaf);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.parent = dec.deserializeOctetString();
        this.legendid = dec.deserializeOctetString();
        this.strSymbol = dec.deserializeOctetString();
        this.strComment = dec.deserializeOctetString();
        this.iIsLeaf = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("parent = ");
        os.print(FStruFormat.convertToString((byte[])this.parent));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("legendid = ");
        os.print(FStruFormat.convertToString((byte[])this.legendid));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strSymbol = ");
        os.print(FStruFormat.convertToString((byte[])this.strSymbol));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strComment = ");
        os.print(FStruFormat.convertToString((byte[])this.strComment));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iIsLeaf = ");
        os.print(this.iIsLeaf.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

