/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnTopoIfCommReq
implements FStruct {
    public BigInteger iUserID;
    public byte[] strMode = null;
    public byte[] strCondition = null;

    public AsnTopoIfCommReq() {
    }

    public AsnTopoIfCommReq(AsnTopoIfCommReq arg) {
        this.iUserID = arg.iUserID;
        if (arg.strMode != null) {
            this.strMode = new byte[arg.strMode.length];
            System.arraycopy(arg.strMode, 0, this.strMode, 0, arg.strMode.length);
        }
        if (arg.strCondition != null) {
            this.strCondition = new byte[arg.strCondition.length];
            System.arraycopy(arg.strCondition, 0, this.strCondition, 0, arg.strCondition.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iUserID);
        if (this.strMode != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strMode);
        }
        if (this.strCondition != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strCondition);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iUserID = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strMode = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strCondition = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iUserID = ");
        os.print(this.iUserID.toString());
        os.println(',');
        if (this.strMode != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strMode = ");
            os.print(FStruFormat.convertToString((byte[])this.strMode));
            os.println(',');
        }
        if (this.strCondition != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strCondition = ");
            os.print(FStruFormat.convertToString((byte[])this.strCondition));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

