/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSnmpSecuParaStrc
implements FStruct {
    public byte[] strUsmUserName;
    public BigInteger iSecurityModel;
    public BigInteger iSecurityLevel;
    public BigInteger iUsmUserAuthProtocol;
    public BigInteger iUsmUserPrivProtocol;
    public byte[] strAuthPassword;
    public byte[] strPrivPassword;

    public AsnSnmpSecuParaStrc() {
    }

    public AsnSnmpSecuParaStrc(AsnSnmpSecuParaStrc arg) {
        this.strUsmUserName = new byte[arg.strUsmUserName.length];
        System.arraycopy(arg.strUsmUserName, 0, this.strUsmUserName, 0, arg.strUsmUserName.length);
        this.iSecurityModel = arg.iSecurityModel;
        this.iSecurityLevel = arg.iSecurityLevel;
        this.iUsmUserAuthProtocol = arg.iUsmUserAuthProtocol;
        this.iUsmUserPrivProtocol = arg.iUsmUserPrivProtocol;
        this.strAuthPassword = new byte[arg.strAuthPassword.length];
        System.arraycopy(arg.strAuthPassword, 0, this.strAuthPassword, 0, arg.strAuthPassword.length);
        this.strPrivPassword = new byte[arg.strPrivPassword.length];
        System.arraycopy(arg.strPrivPassword, 0, this.strPrivPassword, 0, arg.strPrivPassword.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strUsmUserName);
        enc.serializeInteger(this.iSecurityModel);
        enc.serializeInteger(this.iSecurityLevel);
        enc.serializeInteger(this.iUsmUserAuthProtocol);
        enc.serializeInteger(this.iUsmUserPrivProtocol);
        enc.serializeOctetString(this.strAuthPassword);
        enc.serializeOctetString(this.strPrivPassword);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strUsmUserName = dec.deserializeOctetString();
        this.iSecurityModel = dec.deserializeInteger();
        this.iSecurityLevel = dec.deserializeInteger();
        this.iUsmUserAuthProtocol = dec.deserializeInteger();
        this.iUsmUserPrivProtocol = dec.deserializeInteger();
        this.strAuthPassword = dec.deserializeOctetString();
        this.strPrivPassword = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strUsmUserName = ");
        os.print(FStruFormat.convertToString((byte[])this.strUsmUserName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSecurityModel = ");
        os.print(this.iSecurityModel.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSecurityLevel = ");
        os.print(this.iSecurityLevel.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iUsmUserAuthProtocol = ");
        os.print(this.iUsmUserAuthProtocol.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iUsmUserPrivProtocol = ");
        os.print(this.iUsmUserPrivProtocol.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strAuthPassword = ");
        os.print(FStruFormat.convertToString((byte[])this.strAuthPassword));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strPrivPassword = ");
        os.print(FStruFormat.convertToString((byte[])this.strPrivPassword));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

